import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ValidatorDarkM = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 263 182"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M109.88 134.913V180.639C128.507 181.842 148.289 180.061 167.927 175.103C189.394 169.616 207.396 160.086 221.739 148.149C222.509 147.427 223.231 146.657 224.001 145.887L224.964 51.5C224.964 51.5 109.88 136.886 109.88 134.913Z"
            fill="#808B95"
        />
        <path
            d="M233.098 76.2883C232.857 71.8602 231.75 64.6404 230.547 58.4313C229.729 54.3882 226.889 51.1152 222.846 50.1045C206.722 46.1576 181.26 40.093 165.376 37.2532C160.659 36.3868 155.75 37.7345 152.669 41.4407C138.326 58.5276 131.684 68.4909 120.806 85.0484C102.516 112.869 95.2476 145.454 123.79 153.444C142.176 158.594 161.574 151.663 178.227 138.619C201.042 123.939 220.776 99.6806 229.633 88.7546C232.52 85.2891 233.339 80.8128 233.098 76.2883Z"
            fill="#0D7665"
        />
        <path
            d="M144.613 98.2363C147.334 95.5449 147.768 91.5704 145.581 89.3591C143.394 87.1478 139.415 87.537 136.694 90.2284C133.972 92.9198 133.538 96.8942 135.725 99.1055C137.912 101.317 141.891 100.928 144.613 98.2363Z"
            fill="#CCD6E3"
        />
        <path
            d="M169.165 106.554C171.886 103.862 172.305 99.8726 170.099 97.6424C167.894 95.4121 163.9 95.786 161.178 98.4774C158.456 101.169 158.038 105.159 160.243 107.389C162.449 109.619 166.443 109.245 169.165 106.554Z"
            fill="#CCD6E3"
        />
        <path
            d="M218.514 54.1489C218.755 54.2452 218.995 54.4377 219.236 54.5821C219.332 54.6784 219.477 54.7265 219.573 54.8227C219.332 54.6302 219.717 54.9671 219.765 55.0153C220.054 55.2559 220.295 55.4966 220.536 55.7854C220.536 55.7854 220.728 56.0261 220.632 55.8817C220.68 55.9779 220.776 56.0261 220.824 56.1223C220.969 56.3148 221.065 56.4592 221.161 56.6518C221.402 57.085 221.498 57.3737 221.643 57.9032C221.883 58.8658 221.787 60.021 221.498 61.0318C221.402 61.3687 221.258 61.7056 221.161 62.0907C220.921 62.6683 221.209 61.9463 221.113 62.2351C221.065 62.3314 221.065 62.3795 221.017 62.4758C220.872 62.8127 220.728 63.1496 220.584 63.4384C220.247 64.2085 219.91 64.9305 219.525 65.6525C218.707 67.3371 217.84 69.0217 216.926 70.7064C211.968 79.8515 206.288 88.6115 200.224 97.0346C192.715 107.479 184.533 117.491 175.532 126.732C170.815 131.593 165.954 136.359 160.13 139.92C155.365 142.808 150.118 144.878 144.583 145.937C140.684 146.659 136.641 146.899 132.646 146.514C132.309 146.466 131.972 146.466 131.636 146.418C131.443 146.418 131.299 146.37 131.106 146.37C131.058 146.37 130.769 146.322 131.058 146.37C130.962 146.37 130.817 146.322 130.721 146.322C130.143 146.226 129.566 146.129 128.988 146.033C128.266 145.889 127.592 145.744 126.87 145.552C126.774 145.504 126.678 145.504 126.582 145.456C125.234 145.022 124.704 147.092 126.004 147.525C127.4 147.958 128.892 148.199 130.336 148.44C134.09 148.969 137.893 149.017 141.695 148.536C147.134 147.91 152.38 146.322 157.29 143.915C160.226 142.471 162.97 140.739 165.569 138.813C168.457 136.647 171.104 134.193 173.703 131.642C183.233 122.256 191.897 111.956 199.839 101.222C206.337 92.4139 212.401 83.2207 217.744 73.6905C219.525 70.4657 221.258 67.1927 222.75 63.7753C223.712 61.5131 224.386 59.1065 223.472 56.6999C222.846 55.0634 221.691 53.7157 220.247 52.7531C220.006 52.6087 219.814 52.4643 219.573 52.368C219.043 52.1273 218.418 52.2236 218.081 52.7531C217.84 53.1381 217.985 53.8601 218.514 54.1489Z"
            fill="#CCD6E3"
        />
        <path
            d="M188.72 90.9701C168.794 86.2532 153.103 81.3918 142.032 77.3969C140.396 76.8193 139.77 75.0384 140.54 73.45C143.861 67.0003 148.338 60.0212 153.199 53.8603C153.873 52.9939 154.932 52.5126 156.039 52.7532C168.89 55.5449 188.961 60.6469 203.786 64.9788C205.519 65.4601 206.24 67.3854 205.326 68.9738C201.042 76.3861 197.047 82.8839 191.608 89.9112C190.934 90.7776 189.827 91.2108 188.72 90.9701Z"
            fill="#CCD6E3"
        />
        <path
            d="M156.328 125.432C156.28 127.887 154.98 130.101 153.007 131.641C150.552 133.566 147.279 134.529 144.199 134.818C136.979 135.54 128.893 133.422 123.502 128.416C121.48 126.539 119.699 124.036 119.411 121.293C119.122 118.742 120.132 116.431 122.01 114.65C124.224 112.581 127.256 111.57 130.192 111.04C133.946 110.415 137.893 110.752 141.551 111.714C145.017 112.629 148.434 114.169 151.226 116.431C153.488 118.26 155.461 120.619 156.087 123.507C156.28 124.229 156.328 124.758 156.328 125.432C156.328 126.828 158.494 126.828 158.494 125.432C158.494 118.068 151.274 112.966 145.065 110.655C141.07 109.163 136.642 108.441 132.406 108.73C128.844 108.971 125.138 109.885 122.106 111.907C119.555 113.64 117.63 116.191 117.245 119.319C116.86 122.496 118.207 125.576 120.132 128.031C122.443 130.919 125.716 133.085 129.085 134.529C133.032 136.214 137.364 137.128 141.648 137.128C147.953 137.08 156.424 134.625 158.157 127.646C158.349 126.924 158.398 126.202 158.446 125.432C158.542 124.036 156.376 124.036 156.328 125.432Z"
            fill="#CCD6E3"
        />
        <path
            d="M192.282 74.6519C192.282 77.8286 189.49 79.8983 186.602 80.524C183.185 81.2941 179.19 80.3796 176.639 77.9249C174.569 75.9033 173.751 72.7747 175.676 70.3681C177.794 67.6727 181.789 67.047 184.966 67.7208C188.335 68.3466 192.186 70.8013 192.282 74.6519C192.33 75.8552 194.207 75.8552 194.159 74.6519C194.015 70.5606 190.597 67.5283 186.939 66.2769C183.041 64.9773 178.179 65.4105 175.051 68.2984C172.211 70.8976 172.018 75.0369 174.281 78.0693C176.832 81.4385 181.404 83.0269 185.544 82.5937C189.779 82.1123 194.159 79.3207 194.159 74.6519C194.159 73.4004 192.282 73.4004 192.282 74.6519Z"
            fill="#505356"
        />
        <path
            d="M168.121 69.1172C168.025 69.2616 167.832 69.3579 167.64 69.3097C166.725 69.0691 165.811 68.7803 164.896 68.5396C164.752 68.4915 164.704 68.5396 164.608 68.6359C164.271 69.2616 163.934 69.8873 163.597 70.513C163.549 70.6093 163.404 70.6574 163.308 70.6093C162.153 70.2724 160.949 69.9355 159.794 69.5985C159.65 69.5504 159.65 69.5023 159.698 69.3579C160.035 68.7322 160.372 68.1064 160.757 67.4807C160.805 67.3845 160.805 67.3363 160.661 67.2882C159.891 67.0957 159.169 66.855 158.398 66.6625C158.254 66.6143 158.254 66.5662 158.302 66.4699C158.88 65.5073 159.409 64.4965 159.939 63.4858C159.987 63.3895 160.035 63.3414 160.179 63.3895C160.949 63.6301 161.671 63.8227 162.442 64.0152C162.538 64.0633 162.586 64.1115 162.538 64.2077C162.393 64.4484 162.249 64.7372 162.105 64.9778C162.057 65.0741 162.008 65.1222 161.864 65.0741C161.527 64.9778 161.238 64.8816 160.901 64.7853C160.757 64.7372 160.709 64.7853 160.661 64.9297C160.564 65.1704 160.42 65.411 160.276 65.6036C160.179 65.748 160.179 65.7961 160.324 65.8442C161.094 66.0368 161.816 66.2774 162.586 66.4699C162.73 66.5181 162.779 66.5662 162.682 66.7106C162.345 67.3363 162.008 67.962 161.623 68.5396C161.527 68.684 161.575 68.7322 161.864 68.7803C162.105 68.8284 162.345 68.8765 162.538 68.9728C162.73 69.0691 162.827 69.0691 162.875 68.9247C163.212 68.299 163.549 67.6732 163.886 67.0475C163.982 66.9031 164.03 66.9031 164.174 66.9513C165.522 67.3363 166.918 67.7214 168.266 68.1064C168.362 68.1546 168.458 68.2508 168.362 68.3471L168.121 69.1172Z"
            fill="#505356"
            stroke="#505356"
            strokeWidth={0.12033}
            strokeMiterlimit={10}
        />
        <path
            d="M154.21 73.641C154.258 73.5929 154.306 73.5448 154.306 73.4966C155.172 72.0045 155.99 70.5124 156.857 68.9722C156.953 68.8278 156.953 68.7316 156.761 68.7316C155.846 68.539 154.883 68.2021 153.921 67.9133C153.776 67.8652 153.728 67.817 153.824 67.6726C153.969 67.3839 154.161 67.1432 154.306 66.8544C154.354 66.7581 154.402 66.71 154.546 66.7581C156.135 67.2876 157.386 67.5764 158.83 67.9614C159.023 68.0096 158.927 68.0577 158.878 68.154C158.012 69.6461 157.194 71.1863 156.327 72.6784C156.231 72.8228 156.279 72.8709 156.472 72.919C156.905 73.0153 157.338 73.1597 157.771 73.3041C158.108 73.4004 158.493 73.4966 158.83 73.641C158.686 74.0261 158.445 74.3149 158.253 74.6999L154.21 73.641Z"
            fill="#505356"
            stroke="#505356"
            strokeWidth={0.12033}
            strokeMiterlimit={10}
        />
        <path
            d="M159.937 60.7902C159.359 61.8491 159.119 62.6192 158.348 63.63C158.108 63.9669 157.819 63.9669 157.723 63.9188C156.519 63.5818 155.509 63.2931 154.305 62.908C153.92 62.8117 153.728 62.4267 153.92 62.0897C154.498 61.079 154.787 60.5495 155.364 59.5388C155.412 59.4906 155.749 58.913 156.327 59.1056C157.578 59.4425 158.3 59.6831 159.552 60.0201C159.985 60.1645 160.129 60.5014 159.937 60.7902ZM156.038 62.186C156.471 62.3304 156.904 62.4267 157.338 62.5711C157.434 62.5711 157.482 62.5711 157.53 62.4748C157.771 61.9935 158.06 61.5603 158.3 61.079C158.348 60.9827 158.348 60.9346 158.108 60.8864C157.723 60.8383 157.386 60.742 157.049 60.6458C156.471 60.4051 156.471 60.3089 156.327 60.6458C156.182 61.079 155.942 61.464 155.653 61.8972C155.557 62.0416 155.557 62.0898 155.701 62.1379C155.797 62.1379 155.942 62.1379 156.038 62.186Z"
            fill="#505356"
            stroke="#505356"
            strokeWidth={0.12033}
            strokeMiterlimit={10}
        />
        <path
            d="M150.696 68.2496C152.14 68.5865 153.632 68.9716 154.932 69.4529C154.98 69.5011 155.028 69.5492 154.98 69.5973C154.258 70.8006 153.584 72.0521 152.862 73.2554C151.37 72.8222 149.926 72.4371 148.434 72.0039C148.338 72.0039 148.338 71.9077 148.338 71.8595C149.012 70.7044 149.686 69.5492 150.311 68.394C150.456 68.2978 150.552 68.2015 150.696 68.2496ZM150.6 70.8006C150.552 70.8969 150.504 70.9932 150.408 71.0894C150.311 71.2338 150.311 71.2819 150.552 71.3301C151.033 71.4263 151.515 71.5226 151.9 71.7151C152.14 71.8114 152.237 71.8114 152.285 71.667C152.525 71.2338 152.814 70.7525 153.055 70.3193C153.103 70.223 153.103 70.1749 152.959 70.1268C152.429 69.9824 151.9 69.838 151.37 69.6936C151.226 69.6455 151.178 69.6936 151.13 69.7898C150.985 70.1268 150.744 70.4637 150.6 70.8006Z"
            fill="#505356"
            stroke="#505356"
            strokeWidth={0.12033}
            strokeMiterlimit={10}
        />
        <path
            d="M159.842 74.5073C160.42 73.4965 160.998 72.4857 161.575 71.4268C161.623 71.3787 161.72 71.3306 161.768 71.3306C163.164 71.7156 164.559 72.1007 165.907 72.5339C166.148 72.6301 166.051 72.7745 166.003 72.8708C165.378 74.026 164.752 75.133 164.126 76.2882C164.078 76.3363 163.982 76.3844 163.934 76.3844C162.682 76.0475 161.479 75.6625 160.228 75.3255C159.794 75.2293 159.65 74.8442 159.842 74.5073ZM162.057 73.2559C161.864 73.5928 161.671 73.9297 161.479 74.2666C161.431 74.3629 161.431 74.411 161.575 74.4592C162.153 74.6036 162.682 74.7479 163.26 74.9405C163.356 74.9886 163.452 74.9405 163.501 74.8442C163.693 74.411 163.934 73.9778 164.222 73.5446C164.367 73.304 164.271 73.3521 163.741 73.2559C163.356 73.1596 162.971 73.0633 162.634 72.9189C162.393 72.8227 162.345 72.8708 162.249 73.0152C162.153 73.0633 162.105 73.1596 162.057 73.2559Z"
            fill="#505356"
            stroke="#505356"
            strokeWidth={0.12033}
            strokeMiterlimit={10}
        />
        <path
            d="M166.436 62.6197C165.762 63.6305 165.329 64.6412 164.751 65.7001C164.655 65.8927 164.559 65.8927 164.366 65.8445C164.126 65.7483 163.837 65.7001 163.548 65.6039C163.259 65.5076 163.259 65.5558 163.404 65.3151C163.837 64.545 164.27 63.7749 164.703 63.0048C164.8 62.8604 164.751 62.8122 164.607 62.7641C163.404 62.3309 162.297 62.0902 161.141 61.7533C160.997 61.7052 160.949 61.657 161.045 61.5127C161.238 61.2239 161.382 60.8869 161.575 60.5981C161.575 60.5981 164.848 61.4164 166.195 61.9458C166.629 62.0902 166.58 62.4272 166.436 62.6197Z"
            fill="#505356"
            stroke="#505356"
            strokeWidth={0.12033}
            strokeMiterlimit={10}
        />
        <path
            d="M169.371 66.8551C169.275 67.0477 168.986 67.1921 168.745 67.0958C167.879 66.9033 167.061 66.6626 166.194 66.3738C165.906 66.2775 166.146 65.9406 166.194 65.8444C166.772 64.8336 166.965 64.0153 167.735 63.0527C168.023 62.7158 168.12 62.5232 168.553 62.6195C169.419 62.8602 170.286 63.1008 171.152 63.3415C171.2 63.3415 171.248 63.4378 171.2 63.4859C171.056 63.7265 170.96 63.9191 170.815 64.1597C170.719 64.3523 170.43 64.4485 170.189 64.4004C169.756 64.256 169.323 64.1597 168.89 64.0153C168.745 63.9672 168.697 64.0153 168.601 64.1116C168.36 64.5448 168.12 64.978 167.879 65.4112C167.783 65.5556 167.831 65.6037 167.975 65.6518C168.409 65.7962 168.842 65.8925 169.323 66.0369C169.516 66.085 169.612 66.2775 169.516 66.4701L169.371 66.8551Z"
            fill="#505356"
            stroke="#505356"
            strokeWidth={0.12033}
            strokeMiterlimit={10}
        />
        <path
            d="M152.91 64.014C152.958 63.9178 153.103 63.8696 153.199 63.8696C154.98 64.2547 155.942 64.6397 157.29 65.0248C157.531 65.0729 157.483 65.1692 157.338 65.3617C157.194 65.5542 157.098 65.7468 157.001 65.9393C156.905 66.1318 156.857 66.1318 156.713 66.0837C155.75 65.7949 154.787 65.5543 153.873 65.2655C153.728 65.2173 153.632 65.2655 153.584 65.3617C153.247 65.9874 152.862 66.6132 152.525 67.2389C152.477 67.3351 152.429 67.3833 152.236 67.3351C151.851 67.2389 151.466 67.0945 151.081 66.9982L152.91 64.014Z"
            fill="#505356"
            stroke="#505356"
            strokeWidth={0.12033}
            strokeMiterlimit={10}
        />
        <path
            d="M166.965 71.1386C166.821 71.3793 166.532 71.4756 166.243 71.3793C165.81 71.2349 165.425 71.1386 164.992 71.0424C164.799 70.9942 164.799 70.9461 164.944 70.7536C165.088 70.561 165.184 70.3204 165.281 70.1279C165.377 69.9353 165.425 69.8872 165.569 69.9353C166.003 70.0797 166.436 70.176 166.869 70.3204C167.11 70.4167 167.254 70.6092 167.11 70.8498L166.965 71.1386Z"
            fill="#505356"
            stroke="#505356"
            strokeWidth={0.12033}
            strokeMiterlimit={10}
        />
        <path
            d="M159.649 72.1477C159.601 72.2439 159.553 72.3402 159.504 72.4365C159.456 72.5809 159.408 72.629 159.264 72.5327C158.975 72.4365 158.638 72.3402 158.301 72.2439C158.157 72.1958 158.109 72.1958 158.157 72.0514C158.446 71.5701 158.686 71.1369 158.927 70.6556C159.023 70.5112 159.071 70.5593 159.312 70.6556C159.553 70.7519 159.841 70.8481 160.13 70.8962C160.323 70.9444 160.371 70.9444 160.275 71.0888C160.034 71.4257 159.841 71.8108 159.649 72.1477Z"
            fill="#505356"
            stroke="#505356"
            strokeWidth={0.12033}
            strokeMiterlimit={10}
        />
        <path
            d="M91.2522 152.881C91.2522 152.881 110.982 134.126 115 127.02C117.573 122.388 63.9829 90.3213 63.9829 90.3213C63.9829 90.3213 71.658 84.1148 73.3285 77.7734C75.2699 70.4426 70.123 62.8869 66.8723 67.8341C61.274 76.4242 55.3145 80.7867 54.0052 83.9349C52.6959 87.0382 52.6959 102.374 55.2242 114.563C57.301 124.727 61.8609 137.095 64.3441 140.018C66.8272 142.851 91.2522 152.881 91.2522 152.881Z"
            fill="#FAC4B5"
        />
        <path
            d="M124.616 38.6895C127.009 41.298 126.377 44.8959 126.151 46.3801C123.533 62.9757 105.88 119.554 100.191 124.006C93.961 128.818 57.2107 124.501 57.3009 116.54C57.3912 108.085 80.823 42.6472 84.3897 38.3746C87.8661 34.0571 119.47 32.9777 124.616 38.6895Z"
            fill="#222F65"
        />
        <path
            d="M118.025 42.5574C118.882 47.7295 98.2497 116.495 93.6447 119.644C89.0396 122.792 62.2669 116.945 61.2736 114.202C60.2804 111.458 83.1252 44.986 86.6467 41.613C89.9877 38.3748 117.076 36.8007 118.025 42.5574Z"
            fill="#505356"
            stroke="#222F65"
            strokeWidth={0.834554}
            strokeMiterlimit={10}
        />
        <path
            d="M114.323 128.055C119.831 120.904 116.264 116.406 116.264 116.406C116.264 116.406 121.005 114.877 123.037 105.118C123.849 101.34 120.147 97.5169 120.147 97.5169C120.147 97.5169 123.172 94.8634 123.217 90.0061C123.262 85.1489 122.991 81.1911 122.45 73.6354C121.953 67.1141 116.309 68.1486 113.601 74.1302C111.93 77.8181 111.208 88.522 111.208 88.522C111.208 88.522 101.817 87.9823 91.5233 94.1888C89.0402 95.7179 88.4533 100.98 92.2005 102.869C87.8663 105.702 89.4465 111.324 92.8326 112.853C97.5731 115.057 101.275 114.472 101.275 114.472L114.323 128.055Z"
            fill="#FAC4B5"
        />
        <path
            d="M109.627 38.0596C109.627 38.0596 108.633 41.8374 107.144 42.6919C105.654 43.5914 95.6309 43.5914 94.2313 42.647C92.8317 41.7025 94.3216 38.3294 94.3216 38.3294C99.7845 37.5649 104.886 37.5199 109.627 38.0596Z"
            fill="#222F65"
        />
        <path
            d="M116.941 103.408C113.826 101.339 105.429 98.7307 92.2002 102.913"
            stroke="#F3977A"
            strokeWidth={1.66913}
            strokeMiterlimit={10}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M85.0215 131.427C88.8591 126.704 95.4958 124.006 101.591 123.961L103.532 118.384C95.9473 110.963 100.372 106.421 103.938 107.815C107.911 109.389 114.909 114.381 115.361 115.371"
            stroke="#F3977A"
            strokeWidth={1.66913}
            strokeMiterlimit={10}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M118.928 95.0413C117.212 93.0175 114.594 90.4989 112.427 88.9248"
            stroke="#F3977A"
            strokeWidth={1.66913}
            strokeMiterlimit={10}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M102.857 76.0652C102.767 76.3351 102.451 76.515 102.18 76.515C100.735 76.38 99.2905 76.2901 97.8909 76.1552C97.6651 76.1552 97.5748 76.2001 97.4845 76.425C97.1234 77.5044 96.717 78.5838 96.401 79.7081C96.3558 79.888 96.1753 79.978 95.9947 79.978C94.1887 79.7981 92.428 79.6182 90.6221 79.4833C90.3963 79.4833 90.3512 79.3933 90.4415 79.1684C90.8027 78.0891 91.1638 77.0097 91.525 75.9303C91.6153 75.7504 91.5702 75.6604 91.3444 75.6604C90.2157 75.5705 89.1322 75.4805 88.0035 75.3906C87.7777 75.3906 87.7326 75.3006 87.8229 75.1207C88.4098 73.4117 88.9516 71.7027 89.5385 69.9937C89.5837 69.8138 89.674 69.7238 89.8546 69.7688C90.9832 69.8587 92.1119 69.9037 93.2406 69.9937C93.3761 69.9937 93.4664 70.1286 93.4212 70.2635C93.2406 70.7132 93.1052 71.208 92.9698 71.6577C92.9246 71.8376 92.8343 71.9276 92.6086 71.8826C92.1119 71.8376 91.6153 71.8376 91.1638 71.7926C90.9381 71.7926 90.893 71.8826 90.8478 72.1075C90.7575 72.5122 90.6221 72.917 90.4415 73.3218C90.306 73.5916 90.3512 73.6816 90.5769 73.6816C91.7056 73.7715 92.8343 73.8615 93.963 73.9514C94.1887 73.9514 94.2339 74.0414 94.1436 74.2662C93.7824 75.3456 93.4212 76.425 93.0149 77.5044C92.9246 77.7742 93.0149 77.8192 93.4212 77.7742C93.7824 77.7742 94.1436 77.8192 94.4596 77.8642C94.7757 77.9541 94.866 77.9092 94.9563 77.6393C95.3174 76.5599 95.6786 75.4805 96.0398 74.3562C96.1301 74.0863 96.2204 74.0414 96.4461 74.0863C98.5681 74.2662 100.735 74.4461 102.947 74.5811C103.128 74.5811 103.218 74.716 103.173 74.8959L102.857 76.0652Z"
            fill="#EDF2F7"
        />
        <path
            d="M83.7587 87.1719C83.8038 87.0819 83.849 86.992 83.8941 86.902C84.7519 84.3834 85.5646 81.8649 86.4224 79.3463C86.5127 79.1214 86.4676 78.9865 86.1967 78.9865C84.8874 78.9865 83.4878 78.7167 82.1334 78.6267C81.9076 78.6267 81.8625 78.5368 81.9528 78.3119C82.1334 77.8622 82.2688 77.4124 82.4043 76.9627C82.4494 76.7828 82.4946 76.7378 82.6751 76.7378C84.9777 77.0526 86.7385 77.0976 88.8604 77.2775C89.1313 77.2775 89.041 77.4124 88.9958 77.5923C88.138 80.2008 87.2802 82.7644 86.3773 85.2829C86.287 85.5528 86.3321 85.5977 86.603 85.6427C87.2351 85.6877 87.8671 85.7776 88.4992 85.8676C89.041 85.9575 89.5828 85.9575 90.0794 86.0925C89.944 86.6771 89.6731 87.2618 89.5376 87.8465L83.7587 87.1719Z"
            fill="#EDF2F7"
        />
        <path
            d="M88.997 65.7198C88.4101 67.5637 88.2295 68.913 87.3717 70.7119C87.1008 71.3416 86.6945 71.3866 86.6042 71.3866C84.8434 71.2516 83.4438 71.1617 81.683 71.0268C81.0961 70.9818 80.7801 70.4871 81.0058 69.9024C81.5927 68.1484 81.8636 67.2939 82.4054 65.5399C82.4506 65.405 82.7666 64.4605 83.6696 64.5055C85.4755 64.5954 86.559 64.6404 88.3649 64.7303C88.8616 64.7303 89.1324 65.1801 88.997 65.7198ZM83.805 69.2728C84.3919 69.3177 85.024 69.3627 85.6561 69.4077C85.7464 69.4077 85.8818 69.3177 85.9269 69.2278C86.1978 68.4182 86.4687 67.6087 86.7396 66.7992C86.7848 66.6193 86.7396 66.5743 86.4236 66.6193C85.8818 66.6642 85.3852 66.6642 84.8885 66.6193C84.0759 66.4843 83.9856 66.3494 83.8953 66.8441C83.7598 67.5637 83.5341 68.2833 83.2181 68.9579C83.0826 69.2278 83.1278 69.2728 83.3084 69.2728C83.4438 69.2278 83.6244 69.2278 83.805 69.2728Z"
            fill="#EDF2F7"
        />
        <path
            d="M77.8903 80.0215C79.8768 80.1114 81.9084 80.2913 83.8498 80.6062C83.9401 80.6062 84.0304 80.6961 83.9852 80.831C83.308 82.8998 82.6308 84.9237 81.9084 86.9476C79.8316 86.6777 77.8 86.4528 75.8135 86.183C75.7232 86.183 75.6329 86.0481 75.678 85.9581C76.3101 84.0692 76.9422 82.1803 77.5742 80.2913C77.5742 80.2014 77.6645 80.0215 77.8903 80.0215ZM78.2515 83.8443C78.2063 84.0242 78.1612 84.2041 78.0709 84.339C77.9806 84.6089 77.9806 84.6539 78.3418 84.6539C78.9738 84.6539 79.651 84.6988 80.238 84.8787C80.5991 84.9687 80.6894 84.9687 80.7797 84.7438C81.0055 83.9792 81.2764 83.2596 81.5021 82.4951C81.5472 82.3152 81.5472 82.2252 81.3215 82.2252C80.554 82.1803 79.8316 82.0903 79.1093 82.0004C78.9287 81.9554 78.8835 82.0453 78.7932 82.1803C78.6578 82.72 78.432 83.3046 78.2515 83.8443Z"
            fill="#EDF2F7"
        />
        <path
            d="M91.7506 87.0835C92.3375 85.3295 92.9244 83.5755 93.5565 81.8215C93.6017 81.7315 93.692 81.6416 93.8274 81.6416C95.9493 81.8665 98.1164 82.0014 100.284 82.3162C100.69 82.3612 100.6 82.676 100.509 82.8109C99.8321 84.7898 99.1097 86.8137 98.4325 88.7476C98.3873 88.8375 98.2519 88.9275 98.1616 88.9275C96.2654 88.7026 94.3692 88.4777 92.5181 88.2528C91.886 88.1629 91.57 87.6232 91.7506 87.0835ZM94.7304 84.475C94.5046 85.0597 94.324 85.6443 94.0983 86.274C94.0531 86.4539 94.0531 86.4988 94.2337 86.5438C95.0915 86.6338 95.9493 86.7237 96.8071 86.8586C96.9877 86.9036 97.078 86.8586 97.1232 86.6338C97.3489 85.8692 97.5747 85.1046 97.8907 84.385C98.0713 83.9803 97.8907 84.0702 97.078 84.0252C96.4911 84.0252 95.9042 83.9353 95.3624 83.8004C95.0012 83.7104 94.9109 83.8004 94.8658 84.0702C94.8206 84.1602 94.7755 84.3401 94.7304 84.475Z"
            fill="#EDF2F7"
        />
        <path
            d="M98.8394 66.1695C98.0719 68.0585 97.6204 69.8125 96.9883 71.7014C96.898 72.0162 96.7626 72.0612 96.4466 72.0612C96.0402 72.0162 95.6339 72.0162 95.2276 71.9712C94.7761 71.9263 94.8212 72.0162 94.9567 71.5665C95.4082 70.2172 95.8596 68.823 96.3563 67.4288C96.4466 67.159 96.4014 67.114 96.1305 67.069C94.2343 66.7992 92.609 66.8891 90.8482 66.7992C90.6225 66.7992 90.5322 66.7092 90.6225 66.4844C90.8482 65.9447 90.9385 65.36 91.2094 64.8203C91.2094 64.8203 96.2208 64.8653 98.2976 65.1801C99.02 65.2701 99.02 65.7648 98.8394 66.1695Z"
            fill="#EDF2F7"
        />
        <path
            d="M104.256 71.9255C104.121 72.2853 103.714 72.6001 103.308 72.6001C101.953 72.6001 100.599 72.5102 99.2897 72.2853C98.7931 72.1953 99.1091 71.5657 99.1542 71.4308C99.7863 69.5868 99.9218 68.1926 100.87 66.3487C101.186 65.6741 101.321 65.3143 101.999 65.3592C103.398 65.4492 104.798 65.4942 106.242 65.5841C106.333 65.5841 106.423 65.6741 106.378 65.764C106.242 66.1688 106.107 66.5735 105.972 66.9783C105.836 67.3381 105.43 67.608 105.069 67.563C104.346 67.518 103.624 67.473 102.947 67.4281C102.676 67.4281 102.631 67.473 102.54 67.6979C102.269 68.5074 101.999 69.272 101.728 70.0815C101.637 70.3514 101.728 70.3964 101.953 70.3964C102.676 70.4413 103.398 70.4863 104.121 70.5313C104.437 70.5763 104.662 70.8461 104.527 71.1609L104.256 71.9255Z"
            fill="#EDF2F7"
        />
        <path
            d="M79.922 73.0964C79.9671 72.9165 80.1477 72.7816 80.3283 72.8266C82.8566 72.8266 84.211 73.1414 86.1975 73.2763C86.5136 73.3213 86.5136 73.4113 86.333 73.816C86.1975 74.1309 86.0621 74.4906 86.0169 74.8504C85.9718 75.1653 85.8815 75.2102 85.6557 75.2102C84.3013 75.0753 82.9469 74.9854 81.5924 74.8504C81.3667 74.8504 81.2764 74.8954 81.2313 75.1203C80.9152 76.1547 80.554 77.1891 80.238 78.2235C80.1929 78.4034 80.1026 78.4934 79.922 78.4484C79.3802 78.4034 78.8836 78.3584 78.3418 78.3135L79.922 73.0964Z"
            fill="#EDF2F7"
        />
        <path
            d="M101.592 79.7069C101.457 80.1117 101.005 80.3816 100.554 80.3366C99.8766 80.2916 99.2446 80.2016 98.5673 80.1567C98.2513 80.1117 98.2513 80.0218 98.3868 79.7069C98.5673 79.3471 98.7028 78.9424 98.7931 78.5826C98.8834 78.2677 98.9285 78.1778 99.1994 78.2228C99.8766 78.3127 100.554 78.3577 101.231 78.4027C101.637 78.4476 101.863 78.7625 101.728 79.1672L101.592 79.7069Z"
            fill="#EDF2F7"
        />
        <path
            d="M90.9836 83.4391C90.9385 83.619 90.8482 83.7539 90.803 83.9338C90.7579 84.1587 90.7127 84.2486 90.4418 84.2037C89.9904 84.1137 89.4937 84.0687 89.0423 84.0238C88.8165 84.0238 88.7714 83.9788 88.8165 83.7989C89.0874 82.9893 89.3583 82.2248 89.6292 81.4152C89.7195 81.1904 89.8098 81.1904 90.1258 81.2803C90.487 81.3703 90.8933 81.3703 91.2997 81.3703C91.5705 81.3703 91.6157 81.4152 91.5705 81.5951C91.3899 82.2248 91.2094 82.8544 90.9836 83.4391Z"
            fill="#EDF2F7"
        />
        <path
            d="M75.0448 40.937C72.5166 40.3074 69.9883 39.6777 67.46 39.0931C67.0988 39.0031 66.7376 38.9132 66.3764 38.8232C65.338 38.5534 64.1191 39.138 63.8933 40.2174C63.6676 41.2518 64.2093 42.4212 65.2929 42.691C67.8212 43.3207 70.3495 43.9503 72.8777 44.535C73.2389 44.6249 73.6001 44.7149 73.9613 44.8048C74.9997 45.0747 76.2187 44.49 76.4444 43.4106C76.7153 42.3762 76.1735 41.2069 75.0448 40.937Z"
            fill="#CCD6E3"
        />
        <path
            d="M81.7264 33.0684C79.5142 31.2694 77.3019 29.5154 75.0897 27.7164C71.5682 24.8831 68.0918 22.0497 64.5702 19.2612C63.7576 18.6316 62.9449 17.957 62.1774 17.3273C61.3647 16.6527 60.1006 16.4728 59.2879 17.3273C58.6107 18.0469 58.385 19.4861 59.2879 20.2057C61.5002 22.0047 63.7124 23.7587 65.9247 25.5577C69.4462 28.3911 72.9226 31.2245 76.4441 34.0129C77.2568 34.6425 78.0695 35.3171 78.837 35.9468C79.6496 36.6214 80.9138 36.8013 81.7264 35.9468C82.4037 35.1822 82.5842 33.788 81.7264 33.0684Z"
            fill="#CCD6E3"
        />
        <path
            d="M90.6207 28.3445C90.0789 26.1408 89.5372 23.937 88.9954 21.7333C88.9051 21.4185 88.86 21.1037 88.7697 20.7888C88.4988 19.7544 87.2798 19.0348 86.2865 19.3946C85.203 19.7544 84.6161 20.7888 84.8869 21.8682C85.4287 24.072 85.9705 26.2757 86.5123 28.4795C86.6026 28.7943 86.6477 29.1091 86.738 29.4239C87.0089 30.4583 88.2279 31.1779 89.2211 30.8181C90.3047 30.5033 90.8916 29.4689 90.6207 28.3445Z"
            fill="#CCD6E3"
        />
        <path
            d="M93.2849 179.37C96.084 170.24 97.7094 163.359 97.7094 160.526C97.8448 147.303 55.9927 122.747 50.0332 130.887C45.8344 136.599 40.3264 144.02 34.2314 152.25C48.8594 166.192 69.6725 175.502 93.2849 179.37Z"
            fill="#222F65"
        />
        <path
            d="M83.3069 60.6379C88.5441 60.548 93.7812 60.8628 98.9732 61.2676C101.682 61.4924 104.391 61.7623 107.1 62.1221C107.822 62.212 108.454 61.4475 108.454 60.7728C108.454 59.9633 107.822 59.5136 107.1 59.4236C99.6956 58.4791 92.2462 57.9844 84.7968 57.9395C84.3002 57.9395 83.8035 57.9395 83.3069 57.9395C81.5461 57.9844 81.5461 60.6829 83.3069 60.6379Z"
            fill="#A9B1BC"
        />
        <path
            d="M73.3293 92.8386C78.6116 93.5582 83.8939 94.2328 89.131 94.9074C91.7045 95.2672 94.2779 95.582 96.8513 95.8968C97.5737 95.9868 98.2057 95.2222 98.2057 94.5476C98.2057 93.7381 97.5737 93.2883 96.8513 93.1984C89.5374 92.2539 82.1783 91.2645 74.8643 90.32C74.3225 90.2301 73.8259 90.1851 73.2841 90.0951C72.5618 90.0052 71.9297 90.7698 71.9297 91.4444C71.9748 92.2989 72.5618 92.7037 73.3293 92.8386Z"
            fill="#A9B1BC"
        />
        <path
            d="M89.8536 96.4811C90.6211 93.8276 93.2849 92.9731 96.1292 91.8037C97.8899 91.0842 101.502 89.7349 103.804 89.2852C106.152 88.8354 102.224 94.9969 99.1541 95.6266C96.0389 96.2113 89.2215 98.6399 89.8536 96.4811Z"
            fill="#FAC4B5"
        />
    </svg>
);

export default ValidatorDarkM;
