import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ValidatorDark2M = (props: IIconProps): ReactElement => (
    <svg
        viewBox="0 0 263 182"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
        {...props}
    >
        <path
            d="M165.729 11.4255C163.29 10.8384 160.897 10.1158 158.413 10.3868L138.632 12.69C132.039 13.232 126.8 18.4255 126.168 25.0191C122.148 50.1739 119.393 74.7417 118.355 98.5417C117.723 105.135 120.658 110.826 125.49 115.838C139.626 130.651 170.335 153.548 174.445 155.716L174.535 155.806C176.568 157.071 179.142 157.613 181.761 156.935L200.277 152.238C203.122 151.516 205.29 149.122 205.697 146.232C212.923 113.129 218.026 77.7223 221.323 40.6449C221.819 37.3481 219.787 34.5481 216.897 32.832C206.69 26.8255 177.968 14.361 165.729 11.4255Z"
            fill="#78A95E"
        />
        <path
            d="M132.762 97.6363C133.484 98.1783 133.891 98.9912 133.936 99.8492L133.981 101.114C134.071 103.011 134.794 104.681 136.239 106.081C136.33 106.172 136.375 106.217 136.465 106.262L150.149 116.92C151.549 118.094 152.994 118.456 154.53 117.552C154.665 117.462 154.755 117.372 154.891 117.281H154.936C155.975 116.423 157.42 116.423 158.504 117.191L164.42 121.617C166.136 122.927 168.665 121.933 169.026 119.765C172.549 98.675 175.304 78.1718 177.11 58.3912C177.246 56.9008 176.523 55.4105 175.259 54.6428C162.93 46.9654 149.562 39.8299 135.2 33.1009C133.394 32.2428 131.317 33.417 131.091 35.4041C128.923 54.3718 127.026 72.5718 125.491 89.7331C125.355 91.1331 125.988 92.4879 127.071 93.3008L132.762 97.6363Z"
            fill="#377ECC"
        />
        <path
            d="M135.516 42.2705C147.664 48.4576 159.09 54.8705 169.612 61.5544C168.845 71.9415 167.535 81.877 165.638 91.2705C153.399 83.8641 142.109 76.5479 132.761 69.5028C133.122 61.2834 134.161 52.0253 135.516 42.2705Z"
            fill="#CCD6E3"
        />
        <path
            d="M174.354 147.814C178.193 113.175 182.438 80.5232 187.361 51.4394C188.625 45.2974 193.051 40.4652 199.238 39.6974L205.335 38.9297"
            stroke="#CCD6E3"
            strokeWidth={5}
            strokeMiterlimit={10}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M158.865 70.5429C158.82 70.7687 158.684 70.859 158.459 70.7235C157.42 70.0913 156.381 69.3687 155.342 68.7364C155.162 68.6009 155.162 68.6913 155.072 68.8267C154.981 69.7751 154.891 70.7687 154.801 71.7171C154.801 71.8525 154.665 71.8977 154.53 71.8074C153.22 70.9493 151.865 70.0913 150.555 69.2332C150.375 69.0977 150.375 69.0525 150.375 68.8267C150.465 67.8784 150.555 66.93 150.691 65.9816C150.691 65.8461 150.691 65.7558 150.51 65.6203C149.652 65.1235 148.839 64.5364 148.026 64.0396C147.846 63.9042 147.846 63.859 147.846 63.6784C148.026 62.2332 148.162 60.6977 148.297 59.1622C148.297 59.0267 148.342 58.9364 148.478 59.0719C149.336 59.659 150.149 60.1106 151.007 60.6525C151.142 60.7429 151.188 60.8332 151.188 61.0138C151.142 61.3751 151.097 61.8267 151.052 62.188C151.052 62.3235 151.007 62.4138 150.826 62.2784C150.465 62.0525 150.104 61.8267 149.742 61.5558C149.562 61.4203 149.562 61.5106 149.562 61.7364C149.562 62.0977 149.517 62.459 149.426 62.7751C149.381 63.0009 149.426 63.0913 149.562 63.1816C150.42 63.6784 151.233 64.2654 152.091 64.7622C152.272 64.8977 152.317 64.988 152.272 65.1687C152.181 66.1171 152.091 67.0655 151.91 67.9687C151.865 68.1945 151.955 68.2848 152.226 68.4203C152.497 68.5558 152.768 68.6913 152.994 68.9171C153.22 69.1429 153.31 69.1429 153.31 68.9171C153.401 67.9687 153.491 66.9751 153.581 66.0267C153.626 65.8009 153.672 65.8009 153.852 65.9364C155.388 66.93 156.968 67.9235 158.504 68.9171C158.639 69.0074 158.775 69.188 158.684 69.3687L158.865 70.5429Z"
            fill="#222F65"
            stroke="#222F65"
            strokeWidth={0.25}
            strokeMiterlimit={10}
        />
        <path
            d="M146.626 74.518C146.671 74.4728 146.671 74.3825 146.671 74.2922C146.942 72.0341 147.168 69.7761 147.439 67.4728C147.484 67.247 147.439 67.1115 147.258 67.0664C146.265 66.5245 145.181 65.7567 144.142 65.0341C143.962 64.8986 143.916 64.8083 143.962 64.6277C144.007 64.1761 144.097 63.8599 144.097 63.4083C144.097 63.2728 144.142 63.1825 144.278 63.318C146.039 64.5825 147.394 65.3503 148.975 66.3438C149.2 66.4793 149.11 66.5245 149.11 66.6599C148.839 68.918 148.613 71.2664 148.342 73.5245C148.297 73.7503 148.387 73.8406 148.568 73.9761C149.02 74.247 149.516 74.6083 150.013 74.9696C150.375 75.2406 150.826 75.4664 151.187 75.8277C151.187 76.4148 151.052 76.8664 151.007 77.4535L146.626 74.518Z"
            fill="#222F65"
            stroke="#222F65"
            strokeWidth={0.25}
            strokeMiterlimit={10}
        />
        <path
            d="M147.303 54.7356C147.123 56.3614 147.213 57.5356 146.852 59.0259C146.761 59.5227 146.445 59.4775 146.355 59.342C145.045 58.5291 143.961 57.8066 142.607 56.9033C142.2 56.6775 141.884 56.0001 141.929 55.5033C142.11 54.013 142.2 53.2001 142.381 51.7098C142.426 51.6646 142.516 50.7614 143.148 51.213C144.503 52.0259 145.316 52.5678 146.671 53.3807C147.077 53.742 147.348 54.3291 147.303 54.7356ZM144.007 56.1807C144.503 56.4969 144.955 56.7678 145.407 57.084C145.497 57.084 145.542 57.1291 145.542 56.9485C145.587 56.2259 145.723 55.5937 145.768 54.8259C145.768 54.6904 145.768 54.6001 145.497 54.4646C145.09 54.284 144.729 54.0582 144.368 53.8324C143.69 53.3356 143.69 53.1549 143.645 53.6517C143.69 54.3291 143.6 54.9162 143.465 55.5485C143.419 55.7743 143.465 55.8195 143.6 55.9549C143.736 56.0453 143.871 56.0453 144.007 56.1807Z"
            fill="#222F65"
            stroke="#222F65"
            strokeWidth={0.25}
            strokeMiterlimit={10}
        />
        <path
            d="M141.116 64.806C142.652 65.7092 144.232 66.7028 145.723 67.7867C145.768 67.877 145.858 67.9673 145.813 68.0576C145.587 69.8641 145.406 71.7608 145.135 73.5673C143.51 72.4834 141.974 71.4899 140.348 70.406C140.258 70.3608 140.213 70.2254 140.213 70.135C140.439 68.4189 140.619 66.7028 140.8 64.9867C140.89 64.806 140.935 64.6705 141.116 64.806ZM141.974 68.9157C141.974 69.0512 141.974 69.1867 141.884 69.3221C141.839 69.5479 141.884 69.5931 142.11 69.7738C142.606 70.0447 143.103 70.3157 143.555 70.7221C143.826 70.9479 143.916 70.9479 143.916 70.7221C144.006 70.0899 144.097 69.3673 144.142 68.6899C144.142 68.5544 144.142 68.4641 143.961 68.3286C143.374 67.9673 142.832 67.606 142.245 67.2447C142.065 67.1092 142.065 67.1996 142.065 67.335C142.11 67.9221 141.974 68.4189 141.974 68.9157Z"
            fill="#222F65"
            stroke="#222F65"
            strokeWidth={0.25}
            strokeMiterlimit={10}
        />
        <path
            d="M152.587 77.4542C152.768 75.9187 152.948 74.3833 153.129 72.7575C153.174 72.6671 153.219 72.622 153.264 72.6671C154.845 73.6607 156.426 74.6994 157.961 75.7833C158.232 76.0091 158.187 76.2349 158.187 76.3704C158.006 78.1768 157.826 79.8478 157.645 81.6542C157.6 81.7446 157.555 81.7897 157.464 81.7446C156.019 80.8413 154.664 79.8478 153.264 78.9446C152.813 78.6284 152.542 77.951 152.587 77.4542ZM154.348 75.9639C154.303 76.4607 154.213 77.0026 154.168 77.4994C154.168 77.6349 154.168 77.7252 154.348 77.8607C154.98 78.2671 155.613 78.6284 156.245 79.1252C156.38 79.2155 156.426 79.1704 156.471 79.0349C156.471 78.3575 156.561 77.68 156.697 77.0478C156.742 76.6865 156.651 76.7316 156.064 76.4155C155.613 76.1446 155.206 75.8736 154.8 75.5575C154.529 75.3317 154.484 75.422 154.439 75.6026C154.348 75.6478 154.348 75.7833 154.348 75.9639Z"
            fill="#222F65"
            stroke="#222F65"
            strokeWidth={0.25}
            strokeMiterlimit={10}
        />
        <path
            d="M154.53 59.251C154.259 60.7865 154.213 62.3671 154.033 63.9929C154.033 64.3091 153.897 64.2639 153.717 64.1284C153.446 63.9026 153.13 63.7671 152.813 63.5413C152.497 63.3155 152.497 63.4058 152.542 63.0446C152.678 61.8704 152.813 60.6962 152.949 59.522C152.994 59.2962 152.904 59.2058 152.768 59.1155C151.368 58.122 150.194 57.4897 148.884 56.6316C148.704 56.5413 148.659 56.451 148.704 56.2252C148.794 55.7736 148.794 55.2768 148.884 54.8252C148.884 54.8252 152.497 56.9026 154.078 58.122C154.53 58.4381 154.575 58.98 154.53 59.251Z"
            fill="#222F65"
            stroke="#222F65"
            strokeWidth={0.25}
            strokeMiterlimit={10}
        />
        <path
            d="M159.271 67.0643C159.271 67.3804 159 67.5159 158.729 67.2901C157.735 66.7482 156.832 66.1611 155.793 65.4385C155.477 65.2127 155.568 64.7159 155.568 64.5353C155.748 62.9998 155.613 61.645 156.019 60.245C156.2 59.7482 156.2 59.4321 156.697 59.703C157.69 60.2901 158.684 60.9224 159.677 61.5546C159.722 61.5546 159.813 61.7353 159.768 61.8256C159.722 62.1869 159.677 62.503 159.632 62.8643C159.632 63.1804 159.361 63.2708 159.09 63.1353C158.593 62.774 158.097 62.503 157.6 62.1869C157.419 62.0514 157.419 62.1417 157.329 62.2772C157.239 62.9546 157.193 63.6321 157.103 64.2643C157.058 64.4901 157.148 64.5804 157.284 64.6708C157.781 65.0321 158.277 65.303 158.819 65.6643C159.045 65.7998 159.226 66.1611 159.181 66.4321L159.271 67.0643Z"
            fill="#222F65"
            stroke="#222F65"
            strokeWidth={0.25}
            strokeMiterlimit={10}
        />
        <path
            d="M141.658 58.4389C141.658 58.3035 141.793 58.2583 141.883 58.2583C143.78 59.297 144.864 60.1551 146.309 61.1035C146.58 61.239 146.535 61.3744 146.49 61.6454C146.4 61.9164 146.4 62.2325 146.4 62.5035C146.4 62.7744 146.309 62.7744 146.174 62.6841C145.135 61.9615 144.096 61.3744 143.058 60.697C142.877 60.6067 142.832 60.6519 142.832 60.7873C142.742 61.7357 142.606 62.639 142.516 63.5873C142.516 63.7228 142.471 63.8132 142.29 63.6777C141.883 63.4519 141.432 63.0906 141.025 62.8648L141.658 58.4389Z"
            fill="#222F65"
            stroke="#222F65"
            strokeWidth={0.25}
            strokeMiterlimit={10}
        />
        <path
            d="M158.503 73.6573C158.458 74.0186 158.187 74.1089 157.871 73.8831C157.374 73.5218 156.923 73.2508 156.426 72.9799C156.2 72.8444 156.2 72.7541 156.245 72.4831C156.336 72.2121 156.336 71.8057 156.336 71.5347C156.336 71.2186 156.381 71.1734 156.561 71.2638C157.058 71.625 157.555 71.896 158.052 72.2573C158.323 72.4831 158.549 72.8444 158.503 73.2057V73.6573Z"
            fill="#222F65"
            stroke="#222F65"
            strokeWidth={0.25}
            strokeMiterlimit={10}
        />
        <path
            d="M151.458 73.4325C151.458 73.568 151.458 73.7486 151.412 73.8841C151.412 74.1099 151.412 74.2003 151.187 73.9745C150.871 73.7486 150.464 73.4777 150.103 73.2519C149.922 73.1164 149.877 73.1164 149.877 72.8906C149.967 72.168 150.058 71.4906 150.103 70.768C150.148 70.5422 150.193 70.6325 150.509 70.8583C150.78 71.0841 151.096 71.3099 151.412 71.4454C151.638 71.5809 151.683 71.5809 151.638 71.8067C151.548 72.3486 151.503 72.9357 151.458 73.4325Z"
            fill="#222F65"
            stroke="#222F65"
            strokeWidth={0.25}
            strokeMiterlimit={10}
        />
        <path
            d="M135.192 81.7417C136.469 81.2419 136.96 79.4433 136.287 77.7246C135.615 76.0059 134.034 75.0178 132.756 75.5177C131.479 76.0176 130.989 77.8161 131.661 79.5349C132.334 81.2536 133.915 82.2416 135.192 81.7417Z"
            fill="#222F65"
        />
        <path
            d="M144.047 87.8736C145.325 87.3737 145.815 85.5752 145.143 83.8565C144.47 82.1377 142.889 81.1497 141.612 81.6496C140.334 82.1495 139.844 83.948 140.517 85.6667C141.189 87.3854 142.77 88.3735 144.047 87.8736Z"
            fill="#99DD7A"
        />
        <path
            d="M153.187 95.3585C155.068 94.6223 155.775 91.9356 154.766 89.3575C153.758 86.7794 151.415 85.2863 149.533 86.0225C147.652 86.7587 146.945 89.4454 147.954 92.0235C148.963 94.6016 151.305 96.0947 153.187 95.3585Z"
            fill="#FF6757"
        />
        <path
            d="M161.025 99.5689C162.302 99.069 162.793 97.2705 162.12 95.5518C161.448 93.8331 159.867 92.845 158.589 93.3449C157.312 93.8448 156.822 95.6433 157.494 97.362C158.167 99.0807 159.748 100.069 161.025 99.5689Z"
            fill="#CCD6E3"
        />
        <path
            d="M147.374 108.908C149.207 108.059 149.554 104.912 148.148 101.88C146.743 98.8471 144.118 97.0776 142.285 97.9271C140.452 98.7766 140.105 101.924 141.511 104.956C142.916 107.988 145.541 109.758 147.374 108.908Z"
            fill="#FFD34D"
        />
        <path
            d="M140.032 106.174C139.896 106.084 139.761 105.903 139.671 105.722C138.632 103.464 138.18 101.116 138.451 99.0835C138.677 97.0513 139.58 95.6061 140.935 94.9739C141.161 94.8835 141.522 95.1094 141.703 95.5158C141.883 95.9223 141.838 96.3287 141.612 96.419C140.483 96.9158 139.761 98.1352 139.535 99.8061C139.309 101.477 139.716 103.419 140.574 105.316C140.754 105.722 140.709 106.129 140.483 106.219C140.348 106.309 140.212 106.264 140.032 106.174Z"
            fill="#FFD34D"
        />
        <path
            d="M148.296 111.774C148.161 111.683 148.025 111.503 147.935 111.322C147.754 110.916 147.799 110.509 148.025 110.419C149.154 109.922 149.877 108.703 150.102 107.032C150.283 105.361 149.922 103.419 149.064 101.522C148.883 101.116 148.928 100.709 149.154 100.619C149.38 100.529 149.741 100.754 149.922 101.161C150.961 103.419 151.412 105.767 151.141 107.8C150.915 109.832 150.012 111.277 148.657 111.909C148.567 111.909 148.431 111.864 148.296 111.774Z"
            fill="#FFD34D"
        />
        <path
            d="M154.258 86.0329L156.064 82.9619"
            stroke="#FF6757"
            strokeWidth={1.67}
            strokeMiterlimit={10}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M147.168 98.2248L148.703 95.6055"
            stroke="#FF6757"
            strokeWidth={1.67}
            strokeMiterlimit={10}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M147.8 84.9482L144.684 79.9805"
            stroke="#FF6757"
            strokeWidth={1.67}
            strokeMiterlimit={10}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M158.096 101.341L155.025 96.4639"
            stroke="#FF6757"
            strokeWidth={1.67}
            strokeMiterlimit={10}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M91.4393 152.738C91.4393 152.738 111.175 133.906 115.194 126.77C117.768 122.119 64.1619 89.9189 64.1619 89.9189C64.1619 89.9189 71.8393 83.6866 73.5103 77.3189C75.4522 69.9576 70.3038 62.3705 67.0522 67.3382C61.4522 75.964 55.4909 80.3447 54.1812 83.506C52.8716 86.6221 52.8716 102.022 55.4006 114.261C57.478 124.467 62.0393 136.887 64.5232 139.822C67.0522 142.667 91.4393 152.738 91.4393 152.738Z"
            fill="#FAC4B5"
        />
        <path
            d="M124.859 38.071C127.253 40.6904 126.62 44.3033 126.395 45.7936C123.775 62.4581 106.117 119.271 100.427 123.742C94.1946 128.574 57.4333 124.239 57.5236 116.245C57.6139 107.755 81.0526 42.0452 84.6204 37.7549C88.0978 33.4194 119.666 32.3807 124.859 38.071Z"
            fill="#222F65"
        />
        <path
            d="M118.219 41.9573C119.077 47.1508 98.4385 116.202 93.832 119.364C89.2256 122.48 62.4449 116.654 61.4514 113.899C60.4578 111.144 83.3094 44.396 86.832 41.0089C90.2191 37.7573 117.271 36.2218 118.219 41.9573Z"
            fill="#505356"
            stroke="#222F65"
            strokeWidth={3.2251}
            strokeMiterlimit={10}
        />
        <path
            d="M114.562 127.806C120.071 120.625 116.504 116.109 116.504 116.109C116.504 116.109 121.246 114.574 123.278 104.774C124.091 100.98 120.388 97.1414 120.388 97.1414C120.388 97.1414 123.413 94.4769 123.459 89.5995C123.504 84.7221 123.233 80.7479 122.691 73.1608C122.194 66.6124 116.549 67.6511 113.839 73.6576C112.168 77.3608 111.446 88.1092 111.446 88.1092C111.446 88.1092 102.052 87.5673 91.7553 93.7995C89.2715 95.335 88.6844 100.619 92.4328 102.516C88.0973 105.361 89.6779 111.006 93.065 112.541C97.807 114.754 101.51 114.167 101.51 114.167L114.562 127.806Z"
            fill="#FAC4B5"
        />
        <path
            d="M108.013 37.4856C108.013 37.4856 107.02 41.2791 105.529 42.1372C104.039 43.0404 94.0133 43.0404 92.6133 42.092C91.2133 41.1437 92.7036 37.7566 92.7036 37.7566C98.2133 36.9437 103.271 36.8985 108.013 37.4856Z"
            fill="#222F65"
        />
        <path
            d="M117.136 103.06C114.02 100.983 105.62 98.3632 92.3877 102.563"
            stroke="#F3977A"
            strokeWidth={1.67}
            strokeMiterlimit={10}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M85.207 131.195C89.0457 126.453 95.7291 124.231 101.781 123.698L104.13 117.405C96.5425 109.954 100.562 106.085 104.13 107.485C108.104 109.066 115.104 114.079 115.555 115.072"
            stroke="#F3977A"
            strokeWidth={1.67}
            strokeMiterlimit={10}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M119.167 94.6576C117.451 92.6253 114.832 90.0963 112.664 88.5156"
            stroke="#F3977A"
            strokeWidth={1.67}
            strokeMiterlimit={10}
            strokeLinecap="round"
            strokeLinejoin="round"
        />
        <path
            d="M103.045 75.5997C102.955 75.8707 102.639 76.0513 102.368 76.0513C100.923 75.9158 99.4775 75.8255 98.0775 75.69C97.8517 75.69 97.7613 75.7352 97.671 75.961C97.3097 77.0449 96.9033 78.1288 96.5872 79.2578C96.542 79.4384 96.3613 79.5288 96.1807 79.5288C94.3742 79.3481 92.613 79.1675 90.8065 79.032C90.5807 79.032 90.5355 78.9417 90.6259 78.7159C90.9872 77.632 91.3484 76.5481 91.7097 75.4642C91.8001 75.2836 91.7549 75.1933 91.5291 75.1933C90.4001 75.1029 89.3162 75.0126 88.1871 74.9223C87.9613 74.9223 87.9162 74.832 88.0065 74.6513C88.5936 72.9352 89.1355 71.2191 89.7226 69.5029C89.7678 69.3223 89.8581 69.232 90.0388 69.2771C91.1678 69.3675 92.2968 69.4126 93.4259 69.5029C93.5613 69.5029 93.6517 69.6384 93.6065 69.7739C93.4259 70.2255 93.2904 70.7223 93.1549 71.1739C93.1097 71.3546 93.0194 71.4449 92.7936 71.3997C92.2968 71.3546 91.8001 71.3546 91.3484 71.3094C91.1226 71.3094 91.0775 71.3997 91.0323 71.6255C90.942 72.032 90.8065 72.4384 90.6259 72.8449C90.4904 73.1158 90.5355 73.2062 90.7613 73.2062C91.8904 73.2965 93.0194 73.3868 94.1484 73.4771C94.3742 73.4771 94.4194 73.5675 94.3291 73.7933C93.9678 74.8771 93.6065 75.961 93.2001 77.0449C93.1097 77.3159 93.2001 77.361 93.6065 77.3158C93.9678 77.3158 94.3291 77.361 94.6452 77.4062C94.9613 77.4965 95.0517 77.4513 95.142 77.1804C95.5033 76.0965 95.8646 75.0126 96.2259 73.8836C96.3162 73.6126 96.4065 73.5675 96.6323 73.6126C98.7549 73.7933 100.923 73.9739 103.136 74.1094C103.316 74.1094 103.407 74.2449 103.361 74.4255L103.045 75.5997Z"
            fill="#EDF2F7"
        />
        <path
            d="M83.9419 86.7548C83.987 86.6644 84.0322 86.5741 84.0773 86.4838C84.9354 83.9548 85.7483 81.4257 86.6064 78.8967C86.6967 78.6709 86.6515 78.5354 86.3806 78.5354C85.0709 78.5354 83.6709 78.2644 82.3161 78.1741C82.0902 78.1741 82.0451 78.0838 82.1354 77.858C82.3161 77.4064 82.4515 76.9548 82.587 76.5032C82.6322 76.3225 82.6773 76.2773 82.858 76.2773C85.1612 76.5935 86.9225 76.6386 89.0451 76.8193C89.3161 76.8193 89.2257 76.9548 89.1806 77.1354C88.3225 79.7548 87.4644 82.329 86.5612 84.858C86.4709 85.129 86.5161 85.1741 86.787 85.2193C87.4193 85.2644 88.0515 85.3548 88.6838 85.4451C89.2257 85.5354 89.7677 85.5354 90.2644 85.6709C90.129 86.258 89.858 86.8451 89.7225 87.4322L83.9419 86.7548Z"
            fill="#EDF2F7"
        />
        <path
            d="M89.181 65.2131C88.5939 67.0647 88.4133 68.4196 87.5552 70.226C87.2843 70.8583 86.8778 70.9034 86.7875 70.9034C85.0262 70.7679 83.6262 70.6776 81.8649 70.5421C81.2778 70.497 80.9617 70.0002 81.1875 69.4131C81.7746 67.6518 82.0456 66.7938 82.5875 65.0325C82.6327 64.897 82.9488 63.9486 83.852 63.9937C85.6585 64.0841 86.7423 64.1292 88.5488 64.2196C89.0456 64.2196 89.3617 64.6712 89.181 65.2131ZM83.9875 68.7808C84.5746 68.826 85.2068 68.8712 85.8391 68.9163C85.9294 68.9163 86.0649 68.826 86.1101 68.7357C86.381 67.9228 86.652 67.1099 86.923 66.297C86.9681 66.1163 86.923 66.0712 86.6068 66.1163C86.0649 66.1615 85.5681 66.1615 85.0714 66.1163C84.2585 65.9808 84.1681 65.8454 84.0778 66.3421C83.9423 67.0647 83.7165 67.7873 83.4004 68.4647C83.2649 68.7357 83.3101 68.7808 83.4907 68.7808C83.6714 68.7357 83.852 68.7357 83.9875 68.7808Z"
            fill="#EDF2F7"
        />
        <path
            d="M78.1165 79.5742C80.1036 79.6645 82.1359 79.8452 84.0778 80.1613C84.1681 80.1613 84.2584 80.2516 84.2133 80.3871C83.5359 82.4645 82.8584 84.4968 82.1359 86.5291C80.0585 86.2581 78.0262 86.0323 76.0391 85.7613C75.9488 85.7613 75.8585 85.6258 75.9036 85.5355C76.5359 83.6387 77.1681 81.742 77.8004 79.8452C77.8004 79.7549 77.8455 79.5742 78.1165 79.5742ZM78.4778 83.4129C78.4326 83.5936 78.3875 83.7742 78.2972 83.9097C78.2068 84.1807 78.2068 84.2258 78.5681 84.2258C79.2004 84.2258 79.8778 84.271 80.4649 84.4516C80.8262 84.542 80.9165 84.542 81.0068 84.3162C81.2326 83.5484 81.5036 82.8258 81.7294 82.0581C81.7746 81.8774 81.7746 81.7871 81.5488 81.7871C80.781 81.742 80.0585 81.6516 79.3359 81.5613C79.1552 81.5162 79.1101 81.6065 79.0197 81.742C78.8391 82.3291 78.6133 82.871 78.4778 83.4129Z"
            fill="#EDF2F7"
        />
        <path
            d="M91.9816 86.6637C92.5687 84.9024 93.1558 83.1412 93.7881 81.3799C93.8333 81.2895 93.9236 81.1992 94.0591 81.1992C96.1816 81.425 98.3494 81.5605 100.517 81.8766C100.924 81.9218 100.833 82.2379 100.743 82.3734C100.066 84.3605 99.3429 86.3928 98.6655 88.3347C98.6204 88.425 98.4849 88.5153 98.3945 88.5153C96.4978 88.2895 94.601 88.0637 92.7494 87.8379C92.1171 87.7476 91.7558 87.2057 91.9816 86.6637ZM94.9171 84.0444C94.6913 84.6315 94.5107 85.2186 94.2849 85.8508C94.2397 86.0315 94.2397 86.0766 94.4204 86.1218C95.2784 86.2121 96.1365 86.3024 96.9945 86.4379C97.1752 86.4831 97.2655 86.4379 97.3107 86.2121C97.5365 85.4444 97.7623 84.6766 98.0784 83.9541C98.2591 83.5476 98.0784 83.6379 97.2655 83.5928C96.6784 83.5928 96.0913 83.5024 95.5494 83.367C95.1881 83.2766 95.0978 83.367 95.0526 83.6379C95.0074 83.7734 94.9623 83.9089 94.9171 84.0444Z"
            fill="#EDF2F7"
        />
        <path
            d="M99.0714 65.6673C98.3036 67.5641 97.852 69.3254 97.2197 71.2222C97.1294 71.5383 96.9939 71.5835 96.6778 71.5835C96.2713 71.5383 95.8649 71.5383 95.4584 71.4932C95.0068 71.448 95.052 71.5383 95.1875 71.0867C95.6391 69.7319 96.0907 68.3319 96.5875 66.9319C96.6778 66.6609 96.6326 66.6157 96.3617 66.5706C94.4649 66.2996 92.8391 66.3899 91.0778 66.2996C90.852 66.2996 90.7617 66.2093 90.852 65.9835C91.0778 65.4415 91.1681 64.8544 91.4391 64.3125C91.4391 64.3125 96.452 64.3577 98.5294 64.6738C99.2068 64.7641 99.252 65.2609 99.0714 65.6673Z"
            fill="#EDF2F7"
        />
        <path
            d="M104.49 71.445C104.354 71.8063 103.948 72.1224 103.542 72.1224C102.187 72.1224 100.832 72.0321 99.5222 71.8063C99.0254 71.7159 99.3416 71.0837 99.3867 70.9482C100.019 69.0966 100.154 67.6966 101.103 65.845C101.419 65.1676 101.554 64.8063 102.232 64.8514C103.632 64.9418 105.032 64.9869 106.477 65.0772C106.567 65.0772 106.658 65.1676 106.613 65.2579C106.477 65.6643 106.342 66.0708 106.206 66.4772C106.071 66.8385 105.664 67.1095 105.303 67.0643C104.58 67.0192 103.858 66.974 103.18 66.9288C102.909 66.9288 102.864 66.974 102.774 67.1998C102.503 68.0127 102.232 68.7805 101.961 69.5934C101.871 69.8643 101.961 69.9095 102.187 69.9095C102.909 69.9547 103.632 69.9998 104.354 70.045C104.671 70.0901 104.896 70.3611 104.761 70.6772L104.49 71.445Z"
            fill="#EDF2F7"
        />
        <path
            d="M80.1041 72.6196C80.1492 72.4389 80.3299 72.3034 80.5105 72.3486C83.0396 72.3486 84.3944 72.6647 86.3815 72.8002C86.6976 72.8454 86.6976 72.9357 86.517 73.3421C86.3815 73.6583 86.246 74.0196 86.2009 74.3809C86.1557 74.697 86.0654 74.7421 85.8396 74.7421C84.4847 74.6067 83.1299 74.5163 81.775 74.3809C81.5492 74.3809 81.4589 74.426 81.4138 74.6518C81.0976 75.6905 80.7363 76.7292 80.4202 77.7679C80.375 77.9486 80.2847 78.0389 80.1041 77.9937C79.5621 77.9486 79.0654 77.9034 78.5234 77.8583L80.1041 72.6196Z"
            fill="#EDF2F7"
        />
        <path
            d="M101.781 79.259C101.645 79.6655 101.194 79.9365 100.742 79.8913C100.065 79.8461 99.4324 79.7558 98.7549 79.7107C98.4388 79.6655 98.4388 79.5752 98.5743 79.259C98.7549 78.8978 98.8904 78.4913 98.9807 78.13C99.0711 77.8139 99.1162 77.7236 99.3872 77.7687C100.065 77.859 100.742 77.9042 101.419 77.9494C101.826 77.9945 102.052 78.3107 101.916 78.7171L101.781 79.259Z"
            fill="#EDF2F7"
        />
        <path
            d="M91.1678 83.0054C91.1227 83.1861 91.0324 83.3215 90.9872 83.5022C90.942 83.728 90.8969 83.8183 90.6259 83.7732C90.1743 83.6828 89.6775 83.6377 89.2259 83.5925C89.0001 83.5925 88.955 83.5474 89.0001 83.3667C89.2711 82.5538 89.542 81.7861 89.813 80.9732C89.9033 80.7474 89.9937 80.7474 90.3098 80.8377C90.6711 80.928 91.0775 80.928 91.484 80.928C91.7549 80.928 91.8001 80.9732 91.7549 81.1538C91.5743 81.7861 91.3937 82.4183 91.1678 83.0054Z"
            fill="#EDF2F7"
        />
        <path
            d="M75.2259 40.3289C72.6969 39.6966 70.1678 39.0644 67.6388 38.4773C67.2775 38.3869 66.9162 38.2966 66.5549 38.2063C65.5162 37.9353 64.2969 38.5224 64.0711 39.6063C63.8453 40.645 64.3872 41.8192 65.4711 42.0902C68.0001 42.7224 70.5291 43.3547 73.0582 43.9418C73.4194 44.0321 73.7807 44.1224 74.142 44.2128C75.1807 44.4837 76.4001 43.8966 76.6259 42.8128C76.8969 41.774 76.3549 40.5999 75.2259 40.3289Z"
            fill="#EDF2F7"
        />
        <path
            d="M81.91 32.4272C79.6971 30.6208 77.4842 28.8595 75.2713 27.053C71.7487 24.2079 68.2713 21.3627 64.7487 18.5627C63.9358 17.9304 63.1229 17.253 62.3552 16.6208C61.5423 15.9433 60.2778 15.7627 59.4649 16.6208C58.7875 17.3433 58.5617 18.7885 59.4649 19.5111C61.6778 21.3175 63.8907 23.0788 66.1036 24.8853C69.6262 27.7304 73.1036 30.5756 76.6262 33.3756C77.4391 34.0079 78.252 34.6853 79.0197 35.3175C79.8326 35.995 81.0971 36.1756 81.91 35.3175C82.5875 34.595 82.7681 33.1498 81.91 32.4272Z"
            fill="#EDF2F7"
        />
        <path
            d="M90.8519 27.6829C90.31 25.47 89.7681 23.2571 89.2261 21.0442C89.1358 20.7281 89.0907 20.4119 89.0003 20.0958C88.7294 19.0571 87.51 18.3345 86.5165 18.6958C85.4326 19.0571 84.8455 20.0958 85.1165 21.1797C85.6584 23.3926 86.2003 25.6055 86.7423 27.8184C86.8326 28.1345 86.8777 28.4506 86.9681 28.7668C87.239 29.8055 88.4584 30.5281 89.4519 30.1668C90.4907 29.8506 91.1229 28.8119 90.8519 27.6829Z"
            fill="#EDF2F7"
        />
        <path
            d="M93.2907 179.833C96.0004 170.891 97.9423 163.214 97.9423 160.414C98.0778 147.136 56.2133 122.478 50.252 130.652C46.2326 136.162 39.91 144.652 34.0391 152.646C48.6713 166.646 69.5358 175.994 93.2907 179.833Z"
            fill="#222F65"
        />
        <path
            d="M83.4902 60.155C88.7289 60.0647 93.9676 60.3808 99.1612 60.7873C101.871 61.0131 104.581 61.284 107.29 61.6453C108.013 61.7357 108.645 60.9679 108.645 60.2905C108.645 59.4776 108.013 59.026 107.29 58.9356C99.8838 57.9873 92.4322 57.4905 84.9805 57.4453C84.4838 57.4453 83.987 57.4453 83.4902 57.4453C81.7741 57.4453 81.7741 60.155 83.4902 60.155Z"
            fill="#A9B1BC"
        />
        <path
            d="M73.5094 92.4457C78.7932 93.1683 84.0771 93.8457 89.3158 94.5231C91.89 94.8844 94.4642 95.2006 97.0384 95.5167C97.761 95.607 98.3933 94.8393 98.3933 94.1618C98.3933 93.3489 97.761 92.8973 97.0384 92.807C89.7223 91.8586 82.361 90.8651 75.0449 89.9167C74.5029 89.8264 74.0062 89.7812 73.4642 89.6909C72.7416 89.6005 72.1094 90.3683 72.1094 91.0457C72.1545 91.9038 72.7868 92.3554 73.5094 92.4457Z"
            fill="#A9B1BC"
        />
        <path
            d="M90.0389 96.1478C90.8067 93.4833 93.4712 92.6252 96.3163 91.451C98.0776 90.7284 101.691 89.3736 103.994 88.922C106.342 88.4704 102.413 94.6575 99.3422 95.2897C96.2712 95.922 89.4067 98.2704 90.0389 96.1478Z"
            fill="#FAC4B5"
        />
    </svg>
);

export default ValidatorDark2M;
