import React from 'react';

import src from './Fair3D.png';

const Fair3DImage: React.FC<
    Omit<
        React.DetailedHTMLProps<
            React.ImgHTMLAttributes<HTMLImageElement>,
            HTMLImageElement
        >,
        'src'
    >
> = props => {
    const {alt = 'Fair3DImage', ...rest} = props;

    return <img {...rest} src={src} alt={alt} />;
};

export default Fair3DImage;
