import React from 'react';

import src from './PatternWhite.png';

const PatternWhiteImage: React.FC<
    Omit<
        React.DetailedHTMLProps<
            React.ImgHTMLAttributes<HTMLImageElement>,
            HTMLImageElement
        >,
        'src'
    >
> = props => {
    const {alt = 'PatternWhiteImage', ...rest} = props;

    return <img {...rest} src={src} alt={alt} />;
};

export default PatternWhiteImage;
