import React from 'react';

import src from './UnknownCity.png';

const UnknownCityImage: React.FC<
    Omit<
        React.DetailedHTMLProps<
            React.ImgHTMLAttributes<HTMLImageElement>,
            HTMLImageElement
        >,
        'src'
    >
> = props => {
    const {alt = 'UnknownCityImage', ...rest} = props;

    return <img {...rest} src={src} alt={alt} />;
};

export default UnknownCityImage;
