import React from 'react';

import src from './Mail3D.png';

const Mail3DImage: React.FC<
    Omit<
        React.DetailedHTMLProps<
            React.ImgHTMLAttributes<HTMLImageElement>,
            HTMLImageElement
        >,
        'src'
    >
> = props => {
    const {alt = 'Mail3DImage', ...rest} = props;

    return <img {...rest} src={src} alt={alt} />;
};

export default Mail3DImage;
