import React from 'react';

import src from './Reviews3D.png';

const Reviews3DImage: React.FC<
    Omit<
        React.DetailedHTMLProps<
            React.ImgHTMLAttributes<HTMLImageElement>,
            HTMLImageElement
        >,
        'src'
    >
> = props => {
    const {alt = 'Reviews3DImage', ...rest} = props;

    return <img {...rest} src={src} alt={alt} />;
};

export default Reviews3DImage;
