import React from 'react';

import src from './Safety3D.png';

const Safety3DImage: React.FC<
    Omit<
        React.DetailedHTMLProps<
            React.ImgHTMLAttributes<HTMLImageElement>,
            HTMLImageElement
        >,
        'src'
    >
> = props => {
    const {alt = 'Safety3DImage', ...rest} = props;

    return <img {...rest} src={src} alt={alt} />;
};

export default Safety3DImage;
