import React from 'react';

import src from './Support3D.png';

const Support3DImage: React.FC<
    Omit<
        React.DetailedHTMLProps<
            React.ImgHTMLAttributes<HTMLImageElement>,
            HTMLImageElement
        >,
        'src'
    >
> = props => {
    const {alt = 'Support3DImage', ...rest} = props;

    return <img {...rest} src={src} alt={alt} />;
};

export default Support3DImage;
