import React from 'react';

import src from './Tours3D.png';

const Tours3DImage: React.FC<
    Omit<
        React.DetailedHTMLProps<
            React.ImgHTMLAttributes<HTMLImageElement>,
            HTMLImageElement
        >,
        'src'
    >
> = props => {
    const {alt = 'Tours3DImage', ...rest} = props;

    return <img {...rest} src={src} alt={alt} />;
};

export default Tours3DImage;
