import noop from 'lodash/noop';
import Cookie from 'js-cookie';

import {updateAffiliateCookie} from 'utilities/attribution/updateAffiliateCookie';
import AttributionData from 'server/utilities/DataStorage/AttributionData/AttributionData';

const {searchParams} = new URL(location.href);
const attributionData = new AttributionData({
    logger: {
        log: noop,
        logWarn: noop,
        logError: noop,
        addExtra: noop,
    },
    query: Object.fromEntries(searchParams.entries()),
    cookies: Cookie.getJSON(),
    setCookie: Cookie.set,
});

attributionData.updateCookiesAndFillData();
updateAffiliateCookie(location.href);
