import React from 'react';
import _noop from 'lodash/noop';

import {useMobile} from 'utilities/hooks/useMobile';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/account';

import Button from 'components/Button/Button';

import cx from './AccountError.scss';

interface IPassengerErrorProps {
    refreshPage?: () => void;
    goToMain?: () => void;
}

const AccountError: React.FC<IPassengerErrorProps> = ({
    refreshPage = _noop,
    goToMain = _noop,
}) => {
    const isMobile = useMobile();

    return (
        <div
            className={cx('page', {page_mobile: isMobile})}
            {...prepareQaAttributes('account-error')}
        >
            <div className={cx('title')}>{i18nBlock.errorPageDotTitle()}</div>
            <div className={cx('text')}>{i18nBlock.errorPageDotText()}</div>
            <div className={cx('buttons')}>
                <div className={cx('button')}>
                    <Button
                        width="max"
                        size={isMobile ? 'l' : 'm-inset'}
                        onClick={refreshPage}
                    >
                        {i18nBlock.errorPageDotRefresh()}
                    </Button>
                </div>
                <div className={cx('button')}>
                    <Button
                        theme="primary"
                        width="max"
                        size={isMobile ? 'l' : 'm-inset'}
                        onClick={goToMain}
                    >
                        {i18nBlock.errorPageDotMain()}
                    </Button>
                </div>
            </div>
        </div>
    );
};

export default AccountError;
