import React from 'react';

import {
    prepareQaAttributes,
    IWithQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Spinner from 'components/Spinner/Spinner';

import cx from './AccountPreloader.scss';

interface IPreloaderProps extends IWithQaAttributes {
    fixed?: boolean;
}

const AccountPreloader: React.FC<IPreloaderProps> = props => {
    const {fixed = true} = props;

    return (
        <div
            className={cx('wrap', {
                wrap_fixed: fixed,
            })}
            {...prepareQaAttributes(props)}
        >
            <Spinner size="l" />
        </div>
    );
};

export default AccountPreloader;
