import React, {useRef} from 'react';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import MessageBoxPopup from 'components/MessageBoxPopup/MessageBoxPopup';

import cx from './FormError.scss';

interface IFormErrorProps {
    isVisible: boolean;
    inputRef: HTMLInputElement | HTMLDivElement;
    modalRef: HTMLElement;
    error: string;
}

const FormError: React.FC<IFormErrorProps> = props => {
    const {isVisible, inputRef: input, error, modalRef} = props;
    // Берем родительский span, чтобы относительно него позиционировать попап
    const localAnchorRef = useRef<HTMLElement>(input.parentElement);
    const localModalRef = useRef<HTMLElement>(modalRef);

    return (
        <MessageBoxPopup
            isVisible={isVisible}
            anchorRef={localAnchorRef}
            scopeRef={localModalRef}
            viewportOffset={12}
        >
            <div
                className={cx('message')}
                {...prepareQaAttributes('form-error-display')}
            >
                {error}
            </div>
        </MessageBoxPopup>
    );
};

export default FormError;
