import {stringify} from 'querystring';

import {ICoordinates} from 'types/common/ICoordinates';

export function getMapsUrl(coordinates: ICoordinates): string {
    const coordinatesString = [coordinates.lon, coordinates.lat].join(',');

    const queryString = stringify({
        ll: coordinatesString,
        l: 'map',
        pt: coordinatesString,
        rtext: `~${coordinates.lat},${coordinates.lon}`,
        rtt: 'auto',
    });

    return `https://yandex.ru/maps/?${queryString}`;
}
