import React from 'react';

import {URLs} from 'constants/urls';

import {getAbsoluteUrl} from 'utilities/url';

import * as i18nBlock from 'i18n/common';

import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';

const title = i18nBlock.metaDotTitle();
const description = i18nBlock.metaDotDescription();

const AccountPageMeta: React.FC = () => {
    return (
        <SocialSharingMeta
            url={getAbsoluteUrl(URLs.account)}
            title={title}
            description={description}
        />
    );
};

export default AccountPageMeta;
