import React from 'react';

import {EProjectName} from 'constants/common';

import {IWithClassName} from 'types/withClassName';

import TrainIcon16 from 'icons/16/Train';
import HotelIcon16 from 'icons/16/Hotel';
import FlightIcon16 from 'icons/16/Flight';
import TrainIcon12 from 'icons/12/Train';
import HotelIcon12 from 'icons/12/Hotel';
import FlightIcon12 from 'icons/12/Flight';
import BusIcon12 from 'icons/12/Bus';
import BusIcon16 from 'icons/16/Bus';

interface ITicketsIconProps extends IWithClassName {
    type?: EProjectName;
    isSmall?: boolean;
}

const OrderIcon: React.FC<ITicketsIconProps> = ({
    type,
    className,
    isSmall = false,
}) => {
    const TrainIcon = isSmall ? TrainIcon12 : TrainIcon16;
    const HotelIcon = isSmall ? HotelIcon12 : HotelIcon16;
    const FlightIcon = isSmall ? FlightIcon12 : FlightIcon16;
    const BusIcon = isSmall ? BusIcon12 : BusIcon16;

    switch (type) {
        case EProjectName.TRAINS:
            return (
                <div className={className}>
                    <TrainIcon />
                </div>
            );
        case EProjectName.HOTELS:
            return (
                <div className={className}>
                    <HotelIcon />
                </div>
            );
        case EProjectName.AVIA:
            return (
                <div className={className}>
                    <FlightIcon />
                </div>
            );
        case EProjectName.BUSES:
            return (
                <div className={className}>
                    <BusIcon />
                </div>
            );
        default:
            return null;
    }
};

export default OrderIcon;
