import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import EOrderStatusType from 'projects/account/components/OrderStatus/types/EOrderStatusType';

import Flex from 'components/Flex/Flex';

import OrderStatus from './OrderStatus';

export default {
    title: 'Account/OrderStatus',
    component: OrderStatus,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    return (
        <Flex between={2} inline>
            {Object.values(EOrderStatusType).map(status => {
                return <OrderStatus key={status} status={status} />;
            })}
        </Flex>
    );
};

Simple.parameters = {
    info: {
        title: 'Бейджик для заказа в ЛК',
    },
};
