import React from 'react';

import {IWithClassName} from 'types/withClassName';
import EOrderStatusType from './types/EOrderStatusType';

import getTextByOrderStatus from './utilities/getTextByOrderStatus';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import getLabelThemeByOrderStatus from './utilities/getLabelThemeByOrderStatus';

import Label from 'components/Label/Label';

interface IOrderStatusProps extends IWithClassName, IWithQaAttributes {
    status: EOrderStatusType;
}

const OrderStatus: React.FC<IOrderStatusProps> = props => {
    const {status, className} = props;

    const theme = getLabelThemeByOrderStatus(status);
    const text = getTextByOrderStatus(status);

    return (
        <Label
            className={className}
            size="m"
            theme={theme}
            {...prepareQaAttributes(props)}
        >
            {text}
        </Label>
    );
};

export default OrderStatus;
