import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/account-OrderTrains';

import cx from './OrderTrainsCheckin.scss';

interface IOrderTrainsCheckinProps extends IWithClassName, IWithQaAttributes {}

const OrderTrainsCheckin: React.FC<IOrderTrainsCheckinProps> = props => {
    const {className, children} = props;

    return (
        <div
            className={cx('remote', className)}
            {...prepareQaAttributes(props)}
        >
            <div className={cx('remoteIcon')}>
                {i18nBlock.remoteDotShort()}
                <svg className={cx('remoteCross')} width="100%" height="100%">
                    <line x1="0" x2="100%" y1="0" y2="100%" />
                </svg>
            </div>
            <div className={cx('remoteText')}>{children}</div>
        </div>
    );
};

export default OrderTrainsCheckin;
