import {FC, useCallback} from 'react';

import {EAppActions} from 'constants/platforms/TPlatforms';

import {IWithClassName} from 'types/withClassName';
import {ETripsGoal} from 'utilities/metrika/types/goals/trips';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/account-OrdersSearch';

import Button from 'components/Button/Button';

import {useCoordinator} from 'contexts/PlatformContext';

export interface IOrderSearchFormSubmitButtonProps
    extends IWithQaAttributes,
        IWithClassName {}

const OrderSearchFormSubmitButton: FC<IOrderSearchFormSubmitButtonProps> = ({
    className,
    ...props
}) => {
    const {isMobile} = useDeviceType();
    const coordinator = useCoordinator();

    const handleOnSubmitSlick = useCallback(() => {
        coordinator.doAction(EAppActions.REPORT_METRICS_EVENT, {
            name: ETripsGoal.SEARCH_ORDER_SUBMIT_FORM_BUTTON_CLICK,
        });
    }, [coordinator]);

    return (
        <Button
            className={className}
            theme="primary"
            type="submit"
            width="max"
            size={isMobile ? 'l' : 'm-inset'}
            onClick={handleOnSubmitSlick}
            {...prepareQaAttributes(props)}
        >
            {i18nBlock.button()}
        </Button>
    );
};

export default OrderSearchFormSubmitButton;
