import {FC, MouseEventHandler, useCallback} from 'react';

import {EAppActions} from 'constants/platforms/TPlatforms';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/account-OrdersSearch';

import cx from 'projects/account/components/OrdesSearchForm/components/OrdersSearchFormContent/OrdersSearchFormContent.scss';
import Link from 'components/Link/Link';
import {ContainerElement} from '@yandex-lego/components/Link/Link';

import {useCoordinator} from 'contexts/PlatformContext';

export interface IOrdersSearchFormAuthorizeLinkProps
    extends IWithClassName,
        IWithQaAttributes {
    authorizeLink: string;
}

const OrdersSearchFormAuthorizeLink: FC<IOrdersSearchFormAuthorizeLinkProps> =
    ({className, authorizeLink, ...rest}) => {
        const coordinator = useCoordinator();

        const handleOnAuthorizeClick = useCallback<
            MouseEventHandler<ContainerElement>
        >(
            event => {
                const processed = coordinator.doAction(
                    EAppActions.OPEN_AUTHORIZATION,
                );

                if (processed) {
                    event.preventDefault();
                }
            },
            [coordinator],
        );

        return (
            <Link
                key="link"
                url={authorizeLink}
                onClick={handleOnAuthorizeClick}
                className={cx('link')}
                {...prepareQaAttributes(rest)}
            >
                {i18nBlock.link()}
            </Link>
        );
    };

export default OrdersSearchFormAuthorizeLink;
