import {TYandexOrderIdType} from 'server/api/HotelsBookAPI/types/IOrder';

export enum EGroupName {
    ORDERS_SEARCH = 'ordersSearch',
}

export enum EFieldName {
    USER_PRETTY_ID_FIELD_NAME = 'prettyOrderId',
    USER_PHONE_OR_EMAIL_FIELD_NAME = 'userPhoneOrEmail',
}

export type TOrderSearchFormValues = {
    ordersSearch: {
        prettyOrderId: TYandexOrderIdType;
        userPhoneOrEmail: string;
    };
};

export interface IOrderSearchFormValues {
    [EGroupName.ORDERS_SEARCH]?: {
        [EFieldName.USER_PRETTY_ID_FIELD_NAME]?: string;
        [EFieldName.USER_PHONE_OR_EMAIL_FIELD_NAME]?: string;
    };
}
