import {EFormKey} from 'constants/form/EFormKey';

import {IFormValidationInfo} from 'types/common/validation/form';
import {EValidationType} from 'types/common/validation/validation';
import {EGroupName, EFieldName} from '../../types';

import * as i18nBlock from 'i18n/account-Tickets';

const TRAVEL_ORDER_PRETTY_ID_REG_EXP = '(YA-\\d{4}-\\d{4}-\\d{4})';
const TRAIN_ORDER_ID_REG_EXP = '(\\d{5,14})';

const validationInfo: IFormValidationInfo = {
    id: EFormKey.ACCOUNT_ORDER_SEARCH,
    fieldGroups: [
        {
            id: EGroupName.ORDERS_SEARCH,
            fields: [
                {
                    name: EFieldName.USER_PRETTY_ID_FIELD_NAME,
                    validation: {
                        submit: [
                            {
                                type: EValidationType.required,
                                params: true,
                                errorMessage:
                                    i18nBlock.searchDotErrorsDotNumberDotEmpty(),
                            },
                            {
                                type: EValidationType.maxLength,
                                params: 17,
                                errorMessage:
                                    i18nBlock.searchDotErrorsDotNumberDotMaxDotLength(),
                            },
                            {
                                type: EValidationType.regex,
                                params: `^(${TRAVEL_ORDER_PRETTY_ID_REG_EXP}|${TRAIN_ORDER_ID_REG_EXP})$`,
                                errorMessage:
                                    i18nBlock.searchDotErrorsDotNumberDotWrong(),
                            },
                        ],
                    },
                },
                {
                    name: EFieldName.USER_PHONE_OR_EMAIL_FIELD_NAME,
                    validation: {
                        submit: [
                            {
                                type: EValidationType.required,
                                params: true,
                                errorMessage:
                                    i18nBlock.searchDotErrorsDotEmailOrPhoneDotEmpty(),
                            },
                        ],
                    },
                },
            ],
        },
    ],
};

export default validationInfo;
