import React, {useCallback} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IInputChangeEvent} from 'components/Input/types/InputProps';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Input from 'components/Input/Input';
import SearchIcon from 'icons/16/Search';

interface ISearchInputProps extends IWithClassName {
    value: string;
    placeholder: string;
    onChange?(value: string): void;
}

const LENS_ICON = <SearchIcon />;

const SearchInput: React.FC<ISearchInputProps> = props => {
    const {className, value, placeholder, onChange} = props;

    const handleChange = useCallback(
        (e: IInputChangeEvent, changedValue: string) => {
            onChange?.(changedValue);
        },
        [onChange],
    );

    return (
        <Input
            className={className}
            value={value}
            iconRight={LENS_ICON}
            placeholder={placeholder}
            onChange={handleChange}
            hasClear
            {...prepareQaAttributes('passengers-search-input')}
        />
    );
};

export default SearchInput;
