import setFieldData from 'final-form-set-field-data';
import React, {memo} from 'react';

import {
    FOCUS_ON_SUBMIT_ERRORS,
    INITIAL_VALUES,
} from 'projects/account/components/ToursOrderSearchForm/constants';

import {IWithDeviceType} from 'types/withDeviceType';
import {IToursOrderSearchFormValues} from './types';
import {IWithClassName} from 'types/withClassName';
import {TBindToursApiResponse} from 'server/api/ToursApi/types/TBindToursApiResponse';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import validationInfo from 'projects/account/components/ToursOrderSearchForm/utilities/searchToursFormValidate';
import searchToursFormCustomDatesValidation from 'projects/account/components/ToursOrderSearchForm/utilities/searchToursFormCustomDatesValidation';
import {deviceMods} from 'utilities/stylesUtils';

import Form from 'components/Form/Form';
import focusFirstInvalidField from 'components/Form/mutators/focusFirstInvalidField';
import setFormErrors from 'components/Form/mutators/setFormErrors';
import OrderSearchFormContent from './components/ToursOrdersSearchFormContent/ToursOrderSearchFormContent';
import SubmitResult from 'projects/account/components/ToursOrderSearchForm/components/SubmitResult/SubmitResult';

import cx from './ToursOrderSearchForm.scss';

interface IToursOrderSearchFormProps
    extends IWithClassName,
        IWithDeviceType,
        IWithQaAttributes {
    data: TBindToursApiResponse | null;
    handleSubmit: (values: IToursOrderSearchFormValues) => Promise<void>;
    resetForm: () => void;
}

const ToursOrderSearchForm: React.FC<IToursOrderSearchFormProps> = props => {
    const {deviceType, className, handleSubmit, data, resetForm} = props;

    return (
        <div
            className={cx('root', deviceMods('root', deviceType), className)}
            {...prepareQaAttributes(props)}
        >
            <Form<IToursOrderSearchFormValues>
                initialValues={INITIAL_VALUES}
                validationInfo={validationInfo}
                validate={searchToursFormCustomDatesValidation}
                onSubmit={handleSubmit}
                decorators={[FOCUS_ON_SUBMIT_ERRORS]}
                mutators={{
                    focusFirstInvalidField,
                    setFieldData,
                    setFormErrors,
                }}
                render={(renderProps): React.ReactNode => {
                    if (data?.creationStatus) {
                        return (
                            <SubmitResult
                                className={cx('submitResult')}
                                deviceType={deviceType}
                                data={data}
                                resetForm={resetForm}
                            />
                        );
                    }

                    return (
                        <OrderSearchFormContent
                            handleSubmit={renderProps.handleSubmit}
                            deviceType={deviceType}
                            {...prepareQaAttributes({
                                parent: props,
                                current: 'content',
                            })}
                        />
                    );
                }}
            />
        </div>
    );
};

export default memo(ToursOrderSearchForm);
