import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';

import getToursMinDate from 'projects/account/components/ToursOrderSearchForm/utilities/getToursMinDate';
import {getNow} from 'utilities/dateUtils';
import getToursMaxDate from 'projects/account/components/ToursOrderSearchForm/utilities/getToursMaxDate';

import * as i18nBlock from 'i18n/account-ToursOrdersSearch';

import FormField from 'components/FormField/FormField';
import {DatePicker} from 'components/DatePicker/DatePicker';

import cx from './DatePickerField.scss';

export interface IDatePickerFieldProps extends IWithDeviceType {
    fieldName: string;
}

const DatePickerField: React.FC<IDatePickerFieldProps> = ({
    fieldName,
    deviceType,
}) => {
    return (
        <FormField
            key={fieldName}
            deviceType={deviceType}
            name={fieldName}
            className={cx('dateField')}
            title={i18nBlock.datesFieldTitle()}
            control={(
                {input, meta},
                {controlRef},
            ): React.ReactElement<HTMLInputElement> => {
                const startDate = input.value.startDate;
                const endDate = input.value.endDate;
                const isError =
                    meta.error &&
                    meta.submitFailed &&
                    !meta.dirtySinceLastSubmit;
                const minDate = getToursMinDate();
                const maxDate = getToursMaxDate();

                return (
                    <DatePicker
                        className={cx('datePicker')}
                        triggerStartDateRef={startDate ? undefined : controlRef}
                        triggerButtonName={input.name}
                        triggerEndDateRef={startDate ? controlRef : undefined}
                        triggerWithThinBorder
                        errorEndDate={isError && !endDate}
                        errorStartDate={isError && !startDate}
                        isModalView={deviceType.isMobile}
                        deviceType={deviceType}
                        triggerViewType="tile"
                        size={deviceType.isMobile ? 'm' : 's'}
                        hasEndDate
                        isRoundTrip
                        canToggle
                        minDate={minDate}
                        maxDate={maxDate}
                        nowDate={new Date(getNow())}
                        startDate={input.value.startDate}
                        endDate={input.value.endDate}
                        onDaySelect={input.onChange}
                    />
                );
            }}
        />
    );
};

export default DatePickerField;
