import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';
import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/account-ToursOrdersSearch';

import Input from 'components/Input/Input';
import FormField from 'components/FormField/FormField';

export interface IInputFieldProps
    extends IWithDeviceType,
        IWithQaAttributes,
        IWithClassName {
    fieldName: string;
}

const InputField: React.FC<IInputFieldProps> = ({
    fieldName,
    deviceType,
    className,
    ...restProps
}) => {
    return (
        <FormField
            key={fieldName}
            deviceType={deviceType}
            name={fieldName}
            className={className}
            title={i18nBlock.numberFieldTitle()}
            hint={i18nBlock.numberFieldHint()}
            control={(
                {input},
                {inputRef, controlRef, error},
            ): React.ReactElement<HTMLInputElement> => {
                return (
                    <Input
                        {...input}
                        id={input.name}
                        inputRef={(currentInputRef): void => {
                            inputRef.current = currentInputRef;
                        }}
                        innerRef={controlRef}
                        state={error ? 'error' : undefined}
                        value={input.value}
                        size={deviceType.isMobile ? 'l' : 'm'}
                        {...prepareQaAttributes(restProps)}
                    />
                );
            }}
        />
    );
};

export default InputField;
