import React from 'react';

import {EFormKey} from 'constants/form/EFormKey';

import {IWithDeviceType} from 'types/withDeviceType';
import {EFieldName, EGroupName} from '../../types';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/account-ToursOrdersSearch';

import Button from 'components/Button/Button';
import FieldGroup from 'components/Form/components/FieldGroup/FieldGroup';
import Flex from 'components/Flex/Flex';
import DatePickerField from 'projects/account/components/ToursOrderSearchForm/components/DatePickerField/DatePickerField';
import InputField from 'projects/account/components/ToursOrderSearchForm/components/InputField/InputField';

import cx from './ToursOrderSearchFormContent.scss';

interface IToursOrderSearchFormContentProps
    extends IWithDeviceType,
        IWithQaAttributes {
    handleSubmit: () => void;
}

const ToursOrderSearchFormContent: React.FC<IToursOrderSearchFormContentProps> =
    ({deviceType, handleSubmit, ...restProps}) => {
        return (
            <div
                className={cx('root', deviceMods('root', deviceType))}
                {...prepareQaAttributes(restProps)}
            >
                <form
                    name={EFormKey.ACCOUNT_TOURS_ORDER_SEARCH}
                    className={cx('form', deviceMods('form', deviceType))}
                    onSubmit={handleSubmit}
                    noValidate
                >
                    <div
                        className={cx('title')}
                        {...prepareQaAttributes({
                            parent: restProps,
                            current: 'title',
                        })}
                    >
                        {i18nBlock.modalTitle()}
                    </div>
                    <FieldGroup groupId={EGroupName.TOURS_ORDER_SEARCH}>
                        <div className={cx('fields')}>
                            <InputField
                                className={cx('inputField')}
                                fieldName={EFieldName.TOUR_ID}
                                deviceType={deviceType}
                            />
                        </div>
                        <Flex
                            justifyContent="space-between"
                            className={cx('dateFields')}
                        >
                            <DatePickerField
                                fieldName={EFieldName.DATES}
                                deviceType={deviceType}
                            />
                        </Flex>
                    </FieldGroup>
                    <Button
                        className={cx('submitButton')}
                        theme="primary"
                        type="submit"
                        width="max"
                        size={deviceType.isMobile ? 'l' : 'm-inset'}
                        {...prepareQaAttributes({
                            parent: restProps,
                            current: 'searchButton',
                        })}
                    >
                        {i18nBlock.button()}
                    </Button>
                </form>
            </div>
        );
    };

export default ToursOrderSearchFormContent;
