import {EFormKey} from 'constants/form/EFormKey';

import {
    EFieldName,
    EGroupName,
    IToursOrderSearchFormValues,
} from 'projects/account/components/ToursOrderSearchForm/types';

import createSubmitErrorDecorator from 'components/Form/decorators/createSubmitErrorDecorator';

export const FOCUS_ON_SUBMIT_ERRORS =
    createSubmitErrorDecorator<IToursOrderSearchFormValues>(
        EFormKey.ACCOUNT_TOURS_ORDER_SEARCH,
    );

export const INITIAL_VALUES: IToursOrderSearchFormValues = {
    [EGroupName.TOURS_ORDER_SEARCH]: {
        [EFieldName.TOUR_ID]: '',
        [EFieldName.DATES]: {
            startDate: null,
            endDate: null,
        },
    },
};
