import {ReactElement, ReactNode} from 'react';
import moment from 'moment';

import {
    TBindToursApiResponse,
    EBindingCreationStatus,
} from 'server/api/ToursApi/types/TBindToursApiResponse';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {getNow} from 'utilities/dateUtils';

import * as i18nBlock from 'i18n/account-ToursOrdersSearch';

export default function getResultTextByStatus(
    data: TBindToursApiResponse,
    support: ReactNode,
): string | ReactElement {
    switch (data.creationStatus) {
        case EBindingCreationStatus.CREATED:
        case EBindingCreationStatus.ALREADY_BOUND_TO_CURRENT_USER:
            return insertJSXIntoKey(i18nBlock.success)({
                isPast: moment(new Date(getNow())).isAfter(
                    moment(data.expectedTopupDate),
                ),
                date: data.expectedTopupDate,
                support,
            });
        case EBindingCreationStatus.ALREADY_BOUND_TO_OTHER_USER:
            return insertJSXIntoKey(i18nBlock.alreadyBoundToOtherUser)({
                support,
            });
        case EBindingCreationStatus.ORDER_NOT_FOUND:
            return insertJSXIntoKey(i18nBlock.orderNotFound)({support});
        case EBindingCreationStatus.NO_LABEL:
            return i18nBlock.noLabel();
        case EBindingCreationStatus.NON_PLUS_ON_PURCHASE:
            return i18nBlock.nonPlusOnPurchase();
        case EBindingCreationStatus.ORDER_IS_TOO_OLD:
            return i18nBlock.orderIsTooOld();
        case EBindingCreationStatus.ERROR:
        default:
            return insertJSXIntoKey(i18nBlock.oderDefaultError)({support});
    }
}
