import {ValidationErrors} from 'final-form';

import {
    EFieldName,
    EGroupName,
    IToursOrderSearchFormValues,
} from 'projects/account/components/ToursOrderSearchForm/types';

import * as i18nBlock from 'i18n/account-ToursOrdersSearch';

export default function searchToursFormCustomDatesValidation(
    values: IToursOrderSearchFormValues,
): ValidationErrors {
    if (
        !values?.[EGroupName.TOURS_ORDER_SEARCH]?.[EFieldName.DATES].startDate
    ) {
        return {
            [EGroupName.TOURS_ORDER_SEARCH]: {
                [EFieldName.DATES]: i18nBlock.startDateValidationMessage(),
            },
        };
    }

    if (!values?.[EGroupName.TOURS_ORDER_SEARCH]?.[EFieldName.DATES].endDate) {
        return {
            [EGroupName.TOURS_ORDER_SEARCH]: {
                [EFieldName.DATES]: i18nBlock.endDateValidationMessage(),
            },
        };
    }

    return {};
}
