import {EFormKey} from 'constants/form/EFormKey';

import {IFormValidationInfo} from 'types/common/validation/form';
import {EValidationType} from 'types/common/validation/validation';
import {EGroupName, EFieldName} from '../types';

import * as i18nBlock from 'i18n/account-ToursOrdersSearch';

const validationInfo: IFormValidationInfo = {
    id: EFormKey.ACCOUNT_TOURS_ORDER_SEARCH,
    fieldGroups: [
        {
            id: EGroupName.TOURS_ORDER_SEARCH,
            fields: [
                {
                    name: EFieldName.TOUR_ID,
                    validation: {
                        submit: [
                            {
                                type: EValidationType.required,
                                params: true,
                                errorMessage:
                                    i18nBlock.tourIdValidationMessage(),
                            },
                            {
                                type: EValidationType.regex,
                                params: '^[0-9]+$',
                                errorMessage:
                                    i18nBlock.tourIdOnlyNumsValidationMessage(),
                            },
                        ],
                    },
                },
            ],
        },
    ],
};

export default validationInfo;
