import IGenericOrderGetOrderApiResponse from 'server/api/GenericOrderApi/types/getOrder/IGenericOrderGetOrderApiResponse';
import ERefundState from 'server/api/GenericOrderApi/types/common/refund/ERefundState';
import {IRefundPartInfo} from 'server/api/GenericOrderApi/types/common/refund/IRefundPartInfo';

import {isTrainService} from 'projects/trains/lib/order/isTrainService';

/**
 * Проверяет в заказе наличие ошибки возврата
 * @param order
 */
export default function genericOrderHasRefundFailed(
    order: IGenericOrderGetOrderApiResponse,
): boolean {
    return (
        refundPartInfoFailed(order.refundPartInfo) ||
        order.services.some(service => {
            return (
                refundPartInfoFailed(service.refundPartInfo) ||
                (isTrainService(service) &&
                    service.trainInfo?.passengers?.some(passenger => {
                        return refundPartInfoFailed(passenger.refundPartInfo);
                    }))
            );
        })
    );
}

function refundPartInfoFailed(
    refundPartInfo: IRefundPartInfo | null | undefined,
): boolean {
    return refundPartInfo?.refund?.state === ERefundState.FAILED;
}
