import {memo, FC, useMemo} from 'react';
import {useSelector} from 'react-redux';

import {IBusesGenericService} from 'server/api/GenericOrderApi/types/common/TGenericService';

import refundAmountInfoSelector from 'selectors/account/genericOrder/refund/refundAmountInfoSelector';

import getRefundingTickets from 'projects/account/pages/Order/components/GenericOrder/components/BusesOrder/components/BusesRefundModal/utilities/getRefundingTickets';

import * as i18nBlock from 'i18n/account-OrderTrains-Action';

import RefundModal from 'projects/account/pages/Order/components/GenericOrder/components/RefundModal/RefundModal';
import Description from 'projects/account/pages/Order/components/GenericOrder/components/BusesOrder/components/BusesRefundModal/components/Description/Description';

interface IBusesRefundModalProps {
    service: IBusesGenericService;
}

const BusesRefundModal: FC<IBusesRefundModalProps> = props => {
    const {service} = props;

    const refundAmountInfo = useSelector(refundAmountInfoSelector);

    const refundAmountContext = refundAmountInfo.value;

    const refundingTickets = useMemo(
        () => getRefundingTickets(refundAmountInfo.requestParams, service),
        [refundAmountInfo.requestParams, service],
    );

    const title =
        refundingTickets.length > 1
            ? i18nBlock.refundSomeHeader()
            : i18nBlock.refundDotHeader();

    const description = useMemo(() => {
        if (!refundAmountContext) {
            return null;
        }

        return (
            <Description
                refundingTickets={refundingTickets}
                refundAmountContext={refundAmountContext}
            />
        );
    }, [refundAmountContext, refundingTickets]);

    return <RefundModal title={title} description={description} />;
};

export default memo(BusesRefundModal);
