import {memo, FC, useMemo} from 'react';

import IGenericOrderCalculateRefundAmountApiResponse from 'server/api/GenericOrderApi/types/calculateRefundAmount/IGenericOrderCalculateRefundAmountApiResponse';
import {IBusesOrderTicket} from 'types/buses/order/IBusesOrderTicket';

import getFullName from 'projects/account/pages/Order/components/GenericOrder/components/BusesOrder/utilities/getFullName';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/account-OrderTrains-Action';

import Text from 'components/Text/Text';
import Price from 'components/Price/Price';
import Box from 'components/Box/Box';

interface IDescriptionProps {
    refundingTickets: IBusesOrderTicket[];
    refundAmountContext: IGenericOrderCalculateRefundAmountApiResponse;
}

const Description: FC<IDescriptionProps> = props => {
    const {refundingTickets, refundAmountContext} = props;

    const passengersNames = useMemo(
        () => refundingTickets.map(ticket => getFullName(ticket.passenger)),
        [refundingTickets],
    );

    return (
        <Box between={2}>
            <div>{passengersNames.join(', ')}</div>

            {refundAmountContext.refundAmount &&
                Boolean(refundAmountContext.refundAmount.value) && (
                    <div>
                        {insertJSXIntoKey(i18nBlock.refundAmountText)({
                            price: (
                                <Text weight="bold">
                                    <Price
                                        {...refundAmountContext.refundAmount}
                                    />
                                </Text>
                            ),
                        })}
                    </div>
                )}

            <Text color="alert">{i18nBlock.refundDotWarning()}</Text>
        </Box>
    );
};

export default memo(Description);
