import IRefundPartCtx from 'server/api/GenericOrderApi/types/common/refund/IRefundPartCtx';
import {IBusesGenericService} from 'server/api/GenericOrderApi/types/common/TGenericService';
import {IBusesOrderTicket} from 'types/buses/order/IBusesOrderTicket';
import ERefundPartState from 'server/api/GenericOrderApi/types/common/refund/ERefundPartState';

/**
 * Функция возвращает билеты, которые хотим вернуть. Достаем из заказа по контексту возврата.
 *
 * @param refundPartContexts - список контекстов возврата (есть как у билета, так и у сервиса)
 * @param service - автобусный сервис (часть заказа) (для сложных заказов в заказе может быть несколько сервисов)
 */
export default function getRefundingTickets(
    refundPartContexts: IRefundPartCtx[] | null,
    service: IBusesGenericService,
): IBusesOrderTicket[] {
    if (!refundPartContexts) {
        return [];
    }

    return refundPartContexts.reduce<IBusesOrderTicket[]>(
        (tickets, refundPartContext) => {
            if (
                refundPartContext.info === service.refundPartInfo?.context.info
            ) {
                const availableForRefundTickets =
                    service.busInfo.tickets.filter(
                        ticket =>
                            ticket.refundPartInfo?.state ===
                            ERefundPartState.ENABLED,
                    );

                return [...tickets, ...availableForRefundTickets];
            }

            for (const ticket of service.busInfo.tickets) {
                if (
                    ticket.refundPartInfo?.context.info ===
                    refundPartContext.info
                ) {
                    return [...tickets, ticket];
                }
            }

            return tickets;
        },
        [],
    );
}
