import {memo, FC, ReactNode} from 'react';

import {IBusesRide} from 'types/buses/booking/IBusesRide';
import {IWithClassName} from 'types/withClassName';

import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import OrderSegment from 'projects/buses/components/OrderSegment/OrderSegment';
import Box from 'components/Box/Box';

interface IOrderInfoProps extends IWithClassName {
    ride: IBusesRide;
    actions?: ReactNode;
}

const OrderInfo: FC<IOrderInfoProps> = props => {
    const {className, ride, actions} = props;

    return (
        <CardWithDeviceLayout className={className}>
            <OrderSegment ride={ride} />
            {actions && <Box above={5}>{actions}</Box>}
        </CardWithDeviceLayout>
    );
};

export default memo(OrderInfo);
