import {memo, FC, useMemo} from 'react';

import {IBusesOrderTicket} from 'types/buses/order/IBusesOrderTicket';
import {IWithClassName} from 'types/withClassName';
import {IOrderPriceInfo} from 'server/api/HotelsBookAPI/types/IOrder';
import IPaymentInfo from 'server/api/GenericOrderApi/types/common/IPaymentInfo';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import getTotalRefundPrice from 'projects/account/pages/Order/components/GenericOrder/components/BusesOrder/components/Passengers/utilities/getTotalRefundPrice';

import * as i18nPassengers from 'i18n/account-OrderTrains-Passengers';

import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import Heading from 'components/Heading/Heading';
import Separator from 'components/Separator/Separator';
import Intersperse from 'components/Intersperse/Intersperse';
import TotalInfo from 'projects/account/pages/Order/components/GenericOrder/components/BusesOrder/components/Passengers/components/TotalInfo/TotalInfo';
import Tickets from 'projects/account/pages/Order/components/GenericOrder/components/BusesOrder/components/Passengers/components/Tickets/Tickets';

interface ITicketsProps extends IWithClassName {
    tickets: IBusesOrderTicket[];
    priceInfo: IOrderPriceInfo;
    payment: IPaymentInfo | null;
    isRefunding: boolean;
}

const SEPARATOR = <Separator />;

const Passengers: FC<ITicketsProps> = props => {
    const {className, tickets, priceInfo, payment, isRefunding} = props;

    const deviceType = useDeviceType();

    const totalRefundPrice = useMemo(
        () => getTotalRefundPrice(tickets),
        [tickets],
    );

    return (
        <CardWithDeviceLayout className={className} sectioned>
            <Intersperse separator={SEPARATOR}>
                <CardWithDeviceLayout.Section
                    paddingBottom={deviceType.isMobile ? 3 : 4}
                >
                    <Heading level={deviceType.isMobile ? 3 : 2}>
                        {i18nPassengers.title()}
                    </Heading>
                </CardWithDeviceLayout.Section>

                <Tickets tickets={tickets} isRefunding={isRefunding} />

                <TotalInfo
                    priceInfo={priceInfo}
                    payment={payment}
                    totalRefundPrice={totalRefundPrice}
                />
            </Intersperse>
        </CardWithDeviceLayout>
    );
};

export default memo(Passengers);
