import {FC, memo} from 'react';

import {IBusesOrderPassenger} from 'types/buses/order/IBusesOrderPassenger';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import getFullName from 'projects/account/pages/Order/components/GenericOrder/components/BusesOrder/utilities/getFullName';
import getDocumentTitleAndNumber from 'projects/account/pages/Order/components/GenericOrder/components/BusesOrder/components/Passengers/components/Ticket/components/PassengerInfo/utilities/getDocumentTitleAndNumber';
import getBirthDate from 'projects/account/pages/Order/components/GenericOrder/components/BusesOrder/components/Passengers/components/Ticket/components/PassengerInfo/utilities/getBirthDate';
import getSex from 'projects/account/pages/Order/components/GenericOrder/components/BusesOrder/components/Passengers/components/Ticket/components/PassengerInfo/utilities/getSex';

import Text from 'components/Text/Text';
import Intersperse from 'components/Intersperse/Intersperse';
import DotSeparator from 'components/DotSeparator/DotSeparator';

import cx from './PassengerInfo.scss';

interface IPassengerInfoProps {
    passenger: IBusesOrderPassenger;
}

const PassengerInfo: FC<IPassengerInfoProps> = props => {
    const {passenger} = props;

    const deviceType = useDeviceType();

    const fullName = getFullName(passenger);
    const documentTitleAndNumber = getDocumentTitleAndNumber(passenger);
    const birthDate = getBirthDate(passenger);
    const sex = getSex(passenger);

    return (
        <div className={cx(deviceMods('root', deviceType))}>
            <Text
                size={deviceType.isDesktop ? 'l' : 'm'}
                weight="bold"
                tag="div"
            >
                {fullName}
            </Text>

            <div className={cx('info')}>
                <Intersperse
                    separator={deviceType.isDesktop ? <DotSeparator /> : <br />}
                >
                    <span>{documentTitleAndNumber}</span>
                    <span>{birthDate}</span>
                    {sex && <span>{sex}</span>}
                </Intersperse>
            </div>
        </div>
    );
};

export default memo(PassengerInfo);
