import {IBusesOrderPassenger} from 'types/buses/order/IBusesOrderPassenger';

import {formatDate} from 'utilities/dateUtils';
import {HUMAN_DATE_RU} from 'utilities/dateUtils/formats';

import * as i18nPassenger from 'i18n/account-OrderTrains-Passenger';

export default function getBirthDate(passenger: IBusesOrderPassenger): string {
    return i18nPassenger.birthDate({
        date: formatDate(passenger.birthDate, HUMAN_DATE_RU),
    });
}
