import {IBusesOrderPassenger} from 'types/buses/order/IBusesOrderPassenger';

import {formatDocumentNumber} from 'utilities/documents/formatDocumentNumber';

import * as i18n from 'i18n/trains-order-fields';

export default function getDocumentTitleAndNumber(
    passenger: IBusesOrderPassenger,
): string {
    const documentNumber = formatDocumentNumber(
        passenger.documentNumber,
        passenger.documentType,
    );

    return `${i18n.document()}: ${documentNumber}`;
}
