import {IBusesOrderPassenger} from 'types/buses/order/IBusesOrderPassenger';
import {EGender} from 'types/common/document/EGender';

import * as i18nPassenger from 'i18n/account-OrderTrains-Passenger';

export default function getSex(passenger: IBusesOrderPassenger): string | null {
    switch (passenger.sex) {
        case EGender.MALE: {
            return i18nPassenger.genderLabelDotMale();
        }

        case EGender.FEMALE: {
            return i18nPassenger.genderLabelDotFemale();
        }

        default: {
            return null;
        }
    }
}
