import {FC, memo} from 'react';
import first from 'lodash/first';

import {IRefundPartInfo} from 'server/api/GenericOrderApi/types/common/refund/IRefundPartInfo';
import ERefundPartState from 'server/api/GenericOrderApi/types/common/refund/ERefundPartState';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18n from 'i18n/account-OrderTrains-Price';

import Price from 'components/Price/Price';
import DownloadReceiptLink from 'projects/account/pages/Order/components/DownloadReceiptLink/DownloadReceiptLink';
import Flex from 'components/Flex/Flex';

import cx from './Refund.scss';

interface IRefundProps extends IWithClassName {
    refundPartInfo: IRefundPartInfo;
}

const Refund: FC<IRefundProps> = props => {
    const {refundPartInfo, className} = props;

    const deviceType = useDeviceType();

    if (refundPartInfo.state !== ERefundPartState.REFUNDED) {
        return null;
    }

    const amount = refundPartInfo.refund?.refundAmount;
    const receiptUrl = first(refundPartInfo.refund?.paymentRefundReceiptUrls);

    return (
        <Flex
            className={cx('root', className)}
            flexDirection={deviceType.isMobile ? 'column' : 'row'}
            textSize="s"
            between={deviceType.isMobile ? 0 : 5}
            inline={deviceType.isDesktop}
        >
            {amount && (
                <div>
                    {insertJSXIntoKey(i18n.refund)({
                        price: <Price className={cx('price')} {...amount} />,
                        isDesktop: true,
                    })}
                </div>
            )}

            <DownloadReceiptLink
                className={cx('receiptLink')}
                receiptUrl={receiptUrl}
            />
        </Flex>
    );
};

export default memo(Refund);
