import {memo, FC} from 'react';

import {IBusesOrderTicket} from 'types/buses/order/IBusesOrderTicket';
import {IWithClassName} from 'types/withClassName';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import getTicketTypeName from 'projects/buses/utilities/booking/getTicketTypeName';

import * as i18n from 'i18n/buses-OrderPage-Passenger';

import Text from 'components/Text/Text';
import Price from 'components/Price/Price';

interface ITicketInfoProps
    extends IWithClassName,
        Pick<IBusesOrderTicket, 'seat' | 'ticketType' | 'price'> {}

const TicketInfo: FC<ITicketInfoProps> = props => {
    const {className, seat, ticketType, price} = props;

    const ticketTypeWithPrice = insertJSXIntoKey(i18n.ticketTypeWithPrice)({
        ticketType: getTicketTypeName(ticketType),
        price: <Price {...price.total} />,
    });

    return (
        <div className={className}>
            {seat && <div>{i18n.place({place: seat})}</div>}

            <Text color="secondary" size="inherit">
                {ticketTypeWithPrice}
            </Text>
        </div>
    );
};

export default memo(TicketInfo);
