import {memo, FC} from 'react';

import {IBusesOrderTicket} from 'types/buses/order/IBusesOrderTicket';

import Ticket from 'projects/account/pages/Order/components/GenericOrder/components/BusesOrder/components/Passengers/components/Ticket/Ticket';
import Intersperse from 'components/Intersperse/Intersperse';
import Separator from 'components/Separator/Separator';

interface ITicketsProps {
    tickets: IBusesOrderTicket[];
    isRefunding: boolean;
}

const SEPARATOR = <Separator />;

const Tickets: FC<ITicketsProps> = props => {
    const {tickets, isRefunding} = props;

    return (
        <Intersperse separator={SEPARATOR}>
            {tickets.map(ticket => (
                <Ticket
                    key={ticket.id}
                    ticket={ticket}
                    isRefundDisabled={isRefunding}
                />
            ))}
        </Intersperse>
    );
};

export default memo(Tickets);
