import partition from 'lodash/partition';

import EFiscalReceiptType from 'server/api/GenericOrderApi/types/common/EFiscalReceiptType';
import IReceiptItem from 'server/api/GenericOrderApi/types/common/IReceiptItem';

export default function getReceipts(receipts: IReceiptItem[] | undefined): {
    paymentReceipts: IReceiptItem[];
    refundReceipts: IReceiptItem[];
} {
    const [paymentReceipts, refundReceipts] = partition(
        receipts,
        receipt => receipt.type === EFiscalReceiptType.ACQUIRE,
    );

    return {
        paymentReceipts,
        refundReceipts,
    };
}
