import {isNotNull} from 'types/utilities';
import {IBusesOrderTicket} from 'types/buses/order/IBusesOrderTicket';
import IPrice from 'types/common/price/IPrice';

import sumPrice from 'utilities/price/sumPrice';

export default function getTotalRefundPrice(
    tickets: IBusesOrderTicket[],
): IPrice | null {
    const refundAmounts = tickets
        .map(ticket => ticket.refundPartInfo?.refund?.refundAmount || null)
        .filter(isNotNull);

    if (!refundAmounts.length) {
        return null;
    }

    return sumPrice(...refundAmounts);
}
