import {FC, memo, ReactNode, useCallback} from 'react';
import {useDispatch, useSelector} from 'react-redux';

import {EGenericOrderRefundStatus} from 'reducers/account/genericOrder/refund/status/types';

import startRefundAction from 'reducers/account/genericOrder/refund/thunk/startRefundAction';
import closeRefundModalAction from 'reducers/account/genericOrder/refund/thunk/closeRefundModalAction';

import isRefundModalOpenedSelector from 'selectors/account/genericOrder/refund/isRefundModalOpenedSelector';
import refundStatusSelector from 'selectors/account/genericOrder/refund/refundStatusSelector';

import {STATUS} from 'projects/account/lib/orders/actionsStatuses';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nAccountOrderBlock from 'i18n/account-Order';

import OrderActionModal from 'projects/account/pages/Order/components/GenericOrderTrains/components/OrderActionModal/OrderActionModal';

interface IRefundModalProps {
    title: string;
    description: ReactNode;
}

const RefundModal: FC<IRefundModalProps> = props => {
    const {title, description} = props;

    const deviceType = useDeviceType();
    const dispatch = useDispatch();

    const refundStatus = useSelector(refundStatusSelector);
    const isVisible = useSelector(isRefundModalOpenedSelector);

    const status =
        refundStatus === EGenericOrderRefundStatus.CALCULATING_AMOUNT ||
        refundStatus === EGenericOrderRefundStatus.REFUNDING
            ? STATUS.PENDING
            : STATUS.RESOLVE;

    const handleClose = useCallback(() => {
        dispatch(closeRefundModalAction());
    }, [dispatch]);

    const startRefund = useCallback(() => {
        dispatch(startRefundAction());
    }, [dispatch]);

    return (
        <OrderActionModal
            deviceType={deviceType}
            status={status}
            isVisible={isVisible}
            title={title}
            description={description}
            submitName={i18nAccountOrderBlock.actionsDotConfirm()}
            onSubmit={startRefund}
            onClose={handleClose}
        />
    );
};

export default memo(RefundModal);
