import React, {RefObject, useMemo} from 'react';

import IActionItem from './types/IActionItem';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import getActionText from 'projects/account/pages/Order/components/GenericOrderTrains/components/ActionsDialog/utilities/getActionText';
import getActionIcon from 'projects/account/pages/Order/components/GenericOrderTrains/components/ActionsDialog/utilities/getActionIcon';

import CommonActionsDialog from 'components/ActionsDialog/ActionsDialog';

interface IActionsDialogProps extends IWithQaAttributes, IWithQaAttributes {
    actions: IActionItem[];
    isOpened: boolean;
    buttonRef: RefObject<HTMLElement>;
    onClose(): void;
}

const ActionsDialog: React.FC<IActionsDialogProps> = props => {
    const {actions, isOpened, onClose, buttonRef} = props;

    const actionsWithTexts = useMemo(() => {
        return actions.map(action => ({
            id: action.type,
            title: getActionText(action.type),
            icon: getActionIcon(action.type),
            disabled: action.disabled,
            onClick: action.onClick,
        }));
    }, [actions]);

    return (
        <CommonActionsDialog
            buttonRef={buttonRef}
            actions={actionsWithTexts}
            isOpened={isOpened}
            onClose={onClose}
            {...prepareQaAttributes(props)}
        />
    );
};

export default ActionsDialog;
